<?php
// ۹
class DataAction extends BaseAction {
	protected function _initializeMore() {
		$this -> obj = M('sql');
		$this -> backDir = JXCMS_ROOT . 'jxcms/Back/';
	}
	public function defaults() {
		$totalsize = 0;
		$query = $this -> obj -> db() -> query("SHOW TABLE STATUS");
		while ($r = $this -> obj -> db() -> fetchArray($query)) {
			$size = $r['Data_length'] + $r['Index_length'];
			$totalsize += $size;
			$free = $r['Data_free'] ? number_format($r['Data_free'] / 1024, 2) . 'K' : '';
			$table[] = array('name' => $r['Name'], 'row' => $r['Rows'], 'size' => number_format($size / 1024, 2), 'free' => $free);
		}
		$totalsize = number_format($totalsize / (1024 * 1024), 2);
		$this -> assign('table', $table);
		$this -> assign('totalsize', $totalsize);
		$this -> assign('DB_PREFIX', C('DB_PREFIX', 1));
		$this -> display('data');
	}
	public function export() {
		$fileid = max(intval(R('fileid')), 1);
		if ($fileid == 1) {
			if (R('selids')) {
				$random = mt_rand(1000, 9999);
				$tables = explode(',', R('selids'));
				Cache :: write('tmp_bakup_tables', $tables);
			}
		} else {
			$tables = Cache :: read('tmp_bakup_tables');
			$random = R('random');
		}
		if (empty($tables)) $this -> showMsg(L('SELECT_TABLES'));
		$filesize = intval(R('filesize')); //every file size
		if ($filesize < 1024) $filesize = 1024;
		$sqlDump = $this -> obj -> dumpTable($tables, $filesize);
		if (trim($sqlDump)) {
			$backname = R('backname');
			$sqlDump = "#jxcms SQL Dump\n# --------------------------------------------------------\n" . $sqlDump;
			$file = $backname . '_' . date('Ymd') . '_' . $random . '_' . $fileid . '.sql';
			$fileid++;
			FileUtil :: write($this -> backDir . $file, $sqlDump);
			$this -> showMsg($file . L('WRITE_SUCCESS'), '?c=data&a=export&backname=' . $backname . '&filesize=' . $filesize . '&tableid=' . $this -> obj -> tableid . '&fileid=' . $fileid . '&offset=' . $this -> obj -> offset . '&random=' . $random);
		} else {
			Cache :: del('tmp_bakup_tables');
			$this -> showMsg(L('OPERATION_SUCCESS'), '?c=data&a=import');
		}
	}
	public function import() {
		if ($this -> isSubmit) {
			$fileid = max(intval(R('fileid')), 1);
			$fileid = isset($fileid) && $fileid > 0 ? $fileid : 1;
			$file = R('pre') . $fileid . '.sql';
			$path = $this -> backDir . $file;
			if (is_file($path)) {
				$this -> obj -> execute(file_get_contents($path));
				$fileid++;
				$this -> showMsg($file . L('IMPORT_SUCCESS'), '?c=data&a=import&pre=' . R('pre') . '&fileid=' . $fileid . '&submit=1');
			} else $this -> showMsg(L('OPERATION_SUCCESS'), '?c=data&a=import');
		}
		$sqlFiles = glob($this -> backDir . '*.sql');
		if (is_array($sqlFiles)) {
			$info = $data = array();
			foreach($sqlFiles as $id => $sqlFile) {
				$tmpinfo = pathinfo($sqlFile);
				$tmpinfo['filename'] = empty($tmpinfo['filename']) ? substr($tmpinfo['basename'], 0, - strlen($tmpinfo['extension'])-1) : $tmpinfo['filename'];
				preg_match("/([a-z0-9_]+_[0-9]{8}_[0-9a-z]{4}_)([0-9]+)\.sql/i", $tmpinfo['basename'], $num);
				isset($num[0]) or $num = array($tmpinfo['filename'] . '.sql', $tmpinfo['filename'], 0);
				$info['filename'] = $num[0];
				$info['file'] = substr(basename($sqlFile), 0, -4);
				$info['filesize'] = round(filesize($sqlFile) / (1024 * 1024), 2);
				$info['maketime'] = date('Y-m-d H:i:s', filemtime($sqlFile));
				$info['pre'] = $num[1];
				$info['number'] = $num[2];
				$data[] = $info;
			}
		}
		$this -> assign('data', $data);
		$this -> display('data');
	}
	public function repair() {
		$this -> showMsg($this -> obj -> operate('repair'));
	}
	public function optimize() {
		$this -> showMsg($this -> obj -> operate('optimize'));
	}
	public function del() {
		$path = $this -> backDir . R('pre') . '*.sql';
		$sqlFiles = glob($path);
		if (R('pre') && is_array($sqlFiles)) {
			foreach($sqlFiles as $sqlFile) {
				@unlink($sqlFile);
			}
			$sqlFiles = glob($path);
			$this -> showMsg(empty($sqlFiles)?L('OPERATION_SUCCESS'):L('OPERATE_FAIL'), '?c=data&a=import');
		} else $this -> showMsg(L('NOPARAM'));
	}
	public function download() {
		$fileName = R('filename');
		$fileName or $this -> showMsg(L('FILE_NAME_EMPTY'));
		FileUtil :: download($this -> backDir . $fileName . '.sql');
	}
}
