<?php
// Ʒģ
class ProductAction extends BaseAction {
	protected function _initializeMore() {
		$this -> obj = M('product');
		$this -> categoryObj = M('category');
		$this -> assign('category', $this -> categoryObj -> categoryModule('product'));//ñǩĿΪǰģĿ
		//exit($this -> action);
	}
	public function defaults() {
		$page = intval(R('page'));
		$passed = R('passed') === ''?1:intval(R('passed'));
		$recycle = intval(R('recycle'));
		$pageSize = 20;
		$where = array('recycle' => $recycle, 'passed' => $passed);
		if(R('headline')) $where['headline'] = 1;	//ͷϢ
		if(R('elite')) $where['elite'] = 1;	//ƼϢ
		if(R('ontop')) $where['ontop'] = 1;	//öϢ
		$catid = intval(R('catid'));
		if ($catid) {
			$tmp = $this -> categoryObj -> childAll($catid, C('isbigpost', 0, 'product'), true);
			$where[] = count($tmp) > 1?'catid IN (' . implode(', ', $tmp) . ')':'catid=' . intval(current($tmp));
		}
		$q = R('q');
		$q = trim(urldecode($q));
		$q = Func :: FilterSearch($q);
		$this -> assign('q', $q);
		if ($q) {
			$q = explode(' ', $q);
			$or = array();
			foreach($q as $word) {
				if ($word) {
					$or[] = "title LIKE '%$word%'";
					$or[] = "keywords LIKE '%$word%'";
				}
			}
			empty($or) or $where[] = $or;
		}
		if (R('field')) {
			$order = R('order')?strtoupper(R('order')):'DESC';
			$order = R('field') . ' ' . $order;
		} else $order = '';
		$this -> assign('data', $this -> obj -> getList($page, $pageSize, $where, $order));
		$this -> assign('pages', $this -> obj -> pages());
		$this -> assign('catid', intval(R('catid')));
		$this -> assign('passed', $passed);
		$this -> assign('recycle', $recycle);
		$this -> assign('jmpurl', '?' . del_query_string('catid|page|q'));
		$this -> assign('orderurl', '?' . del_query_string('order|field'));
		$this -> assign('order', strtoupper(R('order'))=='DESC'?'ASC':'DESC');
		$this -> display('product');
	}
	public function replace() {
		$info = R('info', 'post');
		is_array($info) or $info = get_cookie('jxcms_data_replace');
		if (empty($info['old'])) $this -> showMsg(L('NOPARAM'));
		else $info['old'] = stripcslashes($info['old']);
		$where = array('passed' => 1, 'recycle' => 0);
		$catid = intval(R('catid'));
		if ($catid) {
			$tmp = $this -> categoryObj -> childAll($catid, C('isbigpost', 0, 'product'), true);
			$where[] = count($tmp) > 1?'catid IN (' . implode(', ', $tmp) . ')':'catid=' . intval(current($tmp));
		}
		$q = trim($info['q']);
		$q = Func :: FilterSearch($q);
		$this -> assign('q', $q);
		if ($q) {
			$q = explode(' ', $q);
			$or = array();
			foreach($q as $word) {
				if ($word) {
					$or[] = "title LIKE '%$word%'";
					$or[] = "content LIKE '%$word%'";
				}
			}
			empty($or) or $where[] = $or;
		}
		$pagesize = $info['work'] == 'replace' ? 500 : 1;
		$field = array('id', 'title', 'content');
		$data = $this -> obj -> field($field) -> limit($pagesize) -> order('updatetime DESC, id DESC') -> where($where) -> select();
		if (empty($data)) $this -> showMsg(L('NO_RESULT'), 'close');
		$pages = $this -> obj -> pages();
		if ($info['work'] == 'replace') {
			$cnt = $success = 0;
			foreach($data as $tmp) {
				$title = Func::replace($tmp['title'], $info['old'], $info['new']);
				$content = Func::replace($tmp['content'], $info['old'], $info['new']);
				if ($title != $tmp['title'] or $content != $tmp['content']) {
					$this -> obj -> setFields(array('title' => $title, 'content' => $content), 'id', $tmp['id']);
					$success++;
				}
				$cnt++;
			}
			$info['cnt'] = empty($info['cnt']) ? $cnt : $info['cnt'] + $cnt;
			$info['success'] = empty($info['success']) ? $success : $info['success'] + $success;
			if (empty($pages)) {
				set_cookie('jxcms_data_replace', '', -1);
				$msg = sprintf(L('REPLACE_RESULT_END'), $info['cnt'], $info['success']);
				$this -> showMsg($msg, 'close');
			} else {
				set_cookie('jxcms_data_replace', $info);
				$msg = sprintf(L('REPLACE_RESULT_STEP'), $cnt, $success);
				$this -> showMsg($msg, 'reload');
			}
		}
		if ($pages) set_cookie('jxcms_data_replace', $info);
		$content = sprintf(L('REPLACE_RESULT'), $data['title'], $data['content']);
		$this -> assign('content', $content);
		$this -> assign('newcontent', Func::replace($content, $info['old'], $info['new']));
		$this -> display('product');
	}
	public function add() {
		if ($this -> isSubmit) {
			$msg = $this -> obj -> save()?L('OPERATE_SUCCESS'):L('OPERATE_FAIL');
			$this -> showMsg($msg, '?c=product&a=add&catid=' . intval($_POST['info']['catid']));
		}
		$this -> assign('attachments', array('', '', '', ''));
		$this -> assign('data', array('id' => 0, 'catid' => intval(R('catid'))));
		$this -> display('product');
	}
	public function edit() {
		if ($this -> isSubmit) {
			$msg = $this -> obj -> save()?L('OPERATE_SUCCESS'):L('OPERATE_FAIL');
			$this -> showMsg($msg, $this -> forward);
		}
		$id = intval(R('id'));
		$this -> assign('data', $this -> obj -> find($id));
		$attachmentObj = M('attachment', '', 'product');
		$attachments = $attachmentObj -> getList('', 0, array('isattach' => 1, 'module' => 'product', 'contentid' => $id), 'orderid ASC, aid DESC');
		$cnt = count($attachments);
		if ($cnt < 4) {
			for($i = $cnt; $i < 4; $i++) {
				$attachments[$i] = '';
			}
		} else {
			$attachments[$cnt] = '';
			$attachments[$cnt + 1] = '';
		}
		$this -> assign('attachments', $attachments);
		$this -> display('product');
	}
	// ͨ
	public function check() {
		if($this -> obj -> setFields(array('checker'=>get_cookie('username'), 'checktime'=>TIME, 'passed'=>1))) $this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
		else $this -> showMsg($this -> error);
	}
	// (ȡ)ö
	public function ontop() {
		if($this -> obj -> setFields(array('ontop'=>intval(R('val'))))) $this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
		else $this -> showMsg($this -> error);
	}
	// (ȡ)ͷ
	public function headline() {
		if($this -> obj -> setFields(array('headline'=>intval(R('val'))))) $this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
		else $this -> showMsg($this -> error);
	}
	// (ȡ)Ƽ
	public function elite() {
		if($this -> obj -> setFields(array('elite'=>intval(R('val'))))) $this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
		else $this -> showMsg($this -> error);
	}
	// ɾվ/ӻվָ
	public function recycle() {
		if($this -> obj -> setFields(array('recycle' => intval(R('val'))))) $this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
		else $this -> showMsg($this -> error);
	}
	// ɾ
	public function del() {
		if($this -> obj -> del()) $this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
		else $this -> showMsg($this -> error);
	}
	// ջվ
	public function delRecycle() {
		if($this -> obj -> del(true)) $this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
		else $this -> showMsg($this -> error);
	}
	// ƶ
	public function move() {
		if($this -> obj -> setFields(array('catid' => intval(R('targetcatid'))))) $this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
		else $this -> showMsg($this -> error);
	}
}
