<?php
class HtmlAction extends Action {
	protected function _initialize() {
		$userid = R('id');
		$hash = R('hash');
		if ($userid && $hash) {
			$data = M('member') -> field(array('username', 'password')) -> where(array('userid' => $userid, 'groupid' => 1)) -> find();
			if ($hash != Func :: getHash($data['username'] . $data['password'])) exit(json_encode(array('result' => 'error')));
		} else exit(json_encode(array('result' => 'error')));
		if ($this -> action != 'contentById') {
			ignore_user_abort(true);
			set_time_limit(0);
			if (Cache :: read('inCreateHtmlLock')) exit(json_encode(array('result' => 'busy')));
			Cache :: write('inCreateHtmlLock', array('hash' => $hash));
		}
		define('IN_CREATEHTML', true);
	}
	public function defaults() {
		$response = array('result' => 'success');
		$indexA = $this -> _A('index');
		// ҳ
		$response['index'] = C('urlmodel') == 1 && $indexA -> defaults()?1:0;
		// ҳ
		$objA = $catids = array();
		$updatehtmlObj = M('updatehtml');
		$data = $updatehtmlObj -> select();
		$cnt = 0;
		if (is_array($data)) {
			foreach($data as $tmp) {
				$pid = $tmp['catid'];
				while ($pid) {
					if (in_array($pid, $catids)) {
						break;
					} else {
						$catids[] = $pid;
						$pid = get_category($pid, 'pid');
					}
				}
				$moduleid = get_category($tmp['catid'], 'moduleid');
				if (!isset($objA[$moduleid])) {
					$module = get_module($moduleid, 'name');
					$objA[$moduleid] = $this -> _A($module);
				}
				$cnt += $objA[$moduleid] -> defaults($tmp['id']);
				$updatehtmlObj -> where(array('catid' => $tmp['catid'], 'id' => $tmp['id'])) -> delete();
			}
		}
		$response['content'] = $cnt;
		// Ŀҳ
		$response['list'] = $this -> _category($catids, $indexA);
		Cache :: del('inCreateHtmlLock');
		$response['time'] = get_run_time();
		exit(json_encode($response));
	}
	// IDHTML
	public function updateById() {
		$m = trim(R('m'));
		$selids = R('selids');
		if ($m && $selids) {
			$cnt = 0;
			$objA = $this -> _A($m);
			$selids = explode(',', $selids);
			foreach($selids as $id) {
				$cnt += $objA -> defaults($id);
			}
			$rs = $cnt;
		} else $rs = 0;
		Cache :: del('inCreateHtmlLock');
		echo $rs;
		exit;
	}
	// HTML
	public function content() {
		$modules = $catids = array();
		$tmpCatids = R('catids');
		if ($tmpCatids == 'all') {
			$tmp = get_module();
			foreach($tmp as $module) {
				if ($module['state'] == 1 && $module['usecategory'] == 1 && C('urlmodel', 0, $module['name']) == 1) {
					$modules[] = $module['name'];
					$catids[$module['name']] = array();
				}
			}
		} else {
			$tmpCatids = explode(',', $tmpCatids);
			foreach($tmpCatids as $catid) {
				if (is_numeric($catid)) {
					$moduleid = get_category($catid, 'moduleid');
					$module = get_module($moduleid, 'name');
					if (C('urlmodel', 0, $module) == 1) {
						in_array($module, $modules) or $modules[] = $module;
						$catids[$module][] = $catid;
					}
				} elseif (substr($catid, 0, 5) == 'model') {
					$module = substr($catid, 6);
					if (C('urlmodel', 0, $module) == 1) {
						$modules[] = $module;
						$catids[$module] = array();
					}
				}
			}
		}
		$cnt = 0;
		foreach($modules as $module) {
			$where = array('passed' => 1, 'recycle' => 0);
			if (!empty($catids[$module])) {
				$where[] = count($catids[$module]) == 1 ? 'catid=' . current($catids[$module]) : 'catid IN(' . implode(',', $catids[$module]) . ')';
			}
			$obj = M($module);
			switch (R('op')) {
				case 'last':
					$obj -> limit(R('number')) -> order('id DESC');
					break;
				case 'time':
					$time = R('starttime');
					if ($time) $where[] = 'updatetime>=' . Func :: timeStamp($time);
					$time = R('endtime');
					if ($time) $where[] = 'updatetime<=' . Func :: timeStamp($time);
					break;
				case 'id':
					$id = intval(R('fromid'));
					if ($id)$where[] = 'id>=' . $id;
					$id = intval(R('toid'));
					if ($id)$where[] = 'id<=' . $id;
					break;
			}
			$data = $obj -> field('id') -> where($where) -> select();
			if ($data) {
				$objA = $this -> _A($module);
				foreach($data as $tmp) {
					$cnt += $objA -> defaults($tmp['id']);
				}
				unset($data);
			}
		}
		$response = array('result' => 'success', 'content' => $cnt, 'time' => get_run_time());
		Cache :: del('inCreateHtmlLock');
		exit(json_encode($response));
	}
	// ĿHTML
	public function category() {
		$catids = R('catids');
		if ($catids == 'all') {
			$categorys = get_category();
			$catids = array();
			foreach($categorys as $tmp) {
				if ($tmp['type'] != 2) {
					if ($tmp['type'] == 1 or C('urlmodel', 0, get_module($tmp['moduleid'], 'name')) == 1) $catids[] = $tmp['catid'];
				}
			}
		} else $catids = explode(',', $catids);
		$response = array('result' => 'success', 'list' => $this -> _category($catids), 'time' => get_run_time());
		Cache :: del('inCreateHtmlLock');
		exit(json_encode($response));
	}
	private function _category($catids, $indexA = '') {
		$indexA or $indexA = $this -> _A('index');
		// Ŀҳ
		$cnt = 0;
		foreach($catids as $catid) {
			$createHtmlPages = 'createHtmlPages';
			Cache :: del($createHtmlPages);
			if ($indexA -> showList($catid, 1)) $cnt++;
			$category = get_category($catid);
			if ($category['type'] == 0) {
				$tmp = Cache :: read($createHtmlPages);
				if ($tmp && $tmp['pages']) {
					for($i = 2; $i <= $tmp['pages']; $i++) {
						if ($indexA -> showList($catid, $i))$cnt++;
					}
				}
			}
		}
		return $cnt;
	}
	/**
	 * ֶؿ
	 *
	 * @param string $className 
	 * @param string $moduleDir ģĿ¼,ڿģʱҪָ
	 */
	private function _A($className, $moduleDir = '') {
		if ($className != 'Action') {
			$className = ucwords($className) . 'Action';
			if (!class_exists($className, false)) {
				$f = get_action_path($className, $moduleDir);
				if (file_exists($f)) include $f;
				else show_error($className . L('ACTION_NOT_EXIST'));
			}
		}
		return new $className();
	}
}