<?php
class IndexAction extends Action {
	public function defaults() {
		$isCreateHtml = defined('IN_CREATEHTML');
		if (C('urlmodel') == 1) {
			$path = Url :: getIndexPath();
			if (is_file($path)) {
				if (!$isCreateHtml) {
					header('Location:' . ROOT_URL . 'index' . C('htmlext'));
					exit;
				}
			} else $isCreateHtml = true;
		}
		$this -> assign('is_index', true);
		$this -> assign('title', C('name'));
		$this -> assign('seotitle', C('seotitle'));
		$this -> assign('keywords', C('keywords'));
		$this -> assign('description', C('description'));
		$tpl = 'index';
		if ($isCreateHtml) {
			$html = $this -> fetch($tpl);
			$size = FileUtil :: write($path , $html);
			if (!defined('IN_CREATEHTML')) {
				echo $html;
			} else {
				return $size;
			}
		} else $this -> display($tpl);
	}
	public function loginBox() {
		if (C('captcha_login', 0, 'member')) {
			$captcha = new Captcha();
			$this -> assign('captcha', $captcha -> code());
		}
		$html = $this -> fetch('login_box');
		echo iconv(C('APP_CHARSET', 1), 'utf-8', $html);
	}
	public function showList($catid = 0, $page = 0) {
		$page or $page = intval(R('page'));
		$page = max(1, $page);
		$catid or $catid = intval(R('catid'));
		$isCreateHtml = defined('IN_CREATEHTML');
		$category = Cache :: read('category', $catid);
		if (empty($category)) {
			if ($isCreateHtml) {
				return false;
			} else show_error(L('CATEGORY_INVALID'));
		}
		$categoryObj = M('category');
		if ($category['showmode'] == 3 && $category['subnum']) {
			$catid = $categoryObj -> categoryChildShow($catid, 'catid');
			$category = Cache :: read('category', $catid);
		}
		if ($category['type'] == 2) { // type == 2,ӷദ
			if ($isCreateHtml) {
				return false;
			} else {
				header("Location:$category[linkurl]");
				exit;
			}
		}

		if ($category['type'] == 0) { // type == 0,ڲĴ
			$module = get_module($category['moduleid']);
			if (empty($module)) {
				if ($isCreateHtml) {
					return false;
				} else show_error(L('MODULE_IS_NOT_EXIST'));
			}

			if (C('urlmodel', 0, $module['name']) == 1) {
				$path = Url :: getListPath($catid, $page);
				$url = Url :: getListUrl($catid, $page);
				if (is_file($path)) {
					if (!$isCreateHtml) {
						header('Location:' . $url);
						exit;
					}
				} else $isCreateHtml = true;
			}
			if ($category['listtpl']) $tpl = $category['listtpl'];
			else $tpl = ($category['subnum'] == 0 or $category['showmode'] == 2)?"{$module['name']}_list":"{$module['name']}_category";

			$this -> assign('catid', $catid);
			$this -> assign('module', $module);
			$this -> assign('title', $category['name']);
			$this -> assign('seotitle', $category['seotitle']);
			$this -> assign('keywords', $category['keywords']);
			$this -> assign('description', $category['description']);
		} else { // type == 1,ҳĴ
			if (C('urlmodel') == 1) {
				$path = Url :: getListPath($catid);
				$url = Url :: getListUrl($catid);
				if (is_file($path)) {
					if (!$isCreateHtml) {
						header('Location:' . $url);
						exit;
					}
				} else $isCreateHtml = true;
			}
			$data = M('onepage') -> where('catid=' . $catid) -> find();
			$data['variable'] = explode("\n", $data['variable']);
			if (is_array($data['variable'])) {
				foreach($data['variable'] as $tmp) {
					list($k, $v) = split('=', $tmp);
					$data[$k] = $v;
				}
			}
			unset($data['variable']);
			if (empty($data['title'])) $data['title'] = $category['name'];
			$data['content'] = Func :: fillDir($data['content']);
			$data['content'] = M('relatedlink') -> show($data['content'], 1, $data['keywords']);
			$this -> assign('extract', $data);
			$tpl = empty($data['tpl'])?'onepage_category':$data['tpl'];
		}
		// Ŀ
		define('STYLE', $categoryObj -> config($catid, 'style'));
		$this -> assign('category', $category);
		$this -> assign('listnum', $categoryObj -> config($catid, 'listnum'));
		$this -> assign('page', $page);
		if ($isCreateHtml) {
			$html = $this -> fetch($tpl);
			$size = FileUtil :: write($path , $html);
			if (!defined('IN_CREATEHTML')) {
				echo $html;
			} else {
				return $size;
			}
		} else $this -> display($tpl);
	}
}
