<?php
class MemberAction extends Action {
	protected function _initialize() {
		$this -> obj = M('member');
	}
	public function defaults() {
		// ʹ ûIDΨһʾΪ
		$user = R('user');
		if ($user) {
			if (is_numeric($user)) {
				$user = intval($user);
			}
			$this -> display('member_space');
		} else {
			$this -> obj -> isLogin() or $this -> showMsg(L('LOGIN_FIRST'), Url :: getUrl('member', 'login'));
			$member = $this -> obj -> find(get_cookie('userid'));
			$this -> assign('member', $member);
			$this -> assign('title', L('USER_CENTER'));
			$this -> display('member_index');
		}
	}
	public function reg() {
		if ($this -> obj -> isLogin()) {
			$go = $this -> referer && !strstr($this -> referer, 'login')?$this -> referer:Url :: getUrl('member');
			$this -> showMsg(L('ALREADY_IS_MEMBER'), $go);
		}
		if ($this -> isSubmit) {
			if ($this -> obj -> reg()) {
				$this -> obj -> login($_POST['info']['username'], $_POST['info']['password']);
				$go = $this -> forward?$this -> forward:Url :: getUrl('member');
				$this -> showMsg(L('REGISTER_SUCCESS'), $go);
			} else $this -> showMsg($this -> obj -> error);
		}
		$this -> assign('title', L('USER_REG'));
		$this -> display('member_reg');
	}
	public function profile() {
		$this -> obj -> isLogin() or $this -> showMsg(L('LOGIN_FIRST'), Url :: getUrl('member', 'login'));
		if ($this -> isSubmit) {
			if ($this -> obj -> edit()) {
				$this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
			} else $this -> showMsg($this -> obj -> error);
		}
		$member = $this -> obj -> find(get_cookie('userid'));
		$tmp = explode('-', $member['birthday']);
		$birthday = array('year' => intval($tmp[0]), 'month' => intval($tmp[1]), 'day' => intval($tmp[2]));
		$birthday['timestamp'] = $member['birthday'] != '0000-00-00' ? Func :: timeStamp($member['birthday']) : '';
		$this -> assign('birthday', $birthday);
		$this -> assign('member', $member);
		$this -> assign('title', L('USER_PROFILE'));
		$this -> display('member_profile');
	}
	public function password() {
		$this -> obj -> isLogin() or $this -> showMsg(L('LOGIN_FIRST'), Url :: getUrl('member', 'login'));
		if ($this -> isSubmit) {
			if ($this -> obj -> password()) {
				$this -> showMsg(L('OPERATE_SUCCESS'), $this -> referer);
			} else $this -> showMsg($this -> obj -> error);
		}
		$member = $this -> obj -> find(get_cookie('userid'));
		$this -> assign('member', $member);
		$this -> assign('title', L('USER_PASSWORD'));
		$this -> display('member_password');
	}
	public function avatar() {
		$this -> obj -> isLogin() or $this -> showMsg(L('LOGIN_FIRST'), Url :: getUrl('member', 'login'));
		$member = $this -> obj -> find(get_cookie('userid'));
		$this -> assign('member', $member);
		$this -> assign('title', L('USER_AVATAR'));
		$this -> display('member_avatar');
	}
	public function checkEmail() {
		$email = iconv('utf-8', C('APP_CHARSET', 1), $_POST['info']['email']);
		echo $this -> obj -> checkEmail($email)?'success':iconv(C('APP_CHARSET', 1), 'utf-8', $this -> obj -> error);
	}
	public function checkUsername() {
		$userName = iconv('utf-8', C('APP_CHARSET', 1), $_POST['info']['username']);
		echo $this -> obj -> checkUsername($userName)?'success':iconv(C('APP_CHARSET', 1), 'utf-8', $this -> obj -> error);
	}
	public function checkPassword() {
		$password = iconv('utf-8', C('APP_CHARSET', 1), $_POST['info']['password']);
		echo $this -> obj -> checkPassword($_POST['info']['password'])?'success':iconv(C('APP_CHARSET', 1), 'utf-8', $this -> obj -> error);
	}
	public function login() {
		if ($this -> isSubmit) {
			$username = iconv('utf-8', C('APP_CHARSET', 1), $_POST['username']);
			$password = iconv('utf-8', C('APP_CHARSET', 1), $_POST['password']);
			$synLogin = $this -> obj -> login($username, $password);
			if ($synLogin) {
				if ($synLogin === true) $synLogin = '';
				$response = array('1', iconv(C('APP_CHARSET', 1), 'utf-8', L('LOGIN_SUCCESS')) . $synLogin);
			} else {
				$response = array('0', iconv(C('APP_CHARSET', 1), 'utf-8', $this -> obj -> error));
			}
			exit(json_encode($response));
		}
		if ($this -> obj -> isLogin()) {
			$go = $this -> referer && !strstr($this -> referer, 'reg')?$this -> referer:Url :: getUrl('member');
			$this -> showMsg(L('ALREADY_LOGIN'), $go);
		}
		$this -> assign('title', L('USER_LOGIN'));
		$this -> assign('forward', R('forward')?R('forward'):$this -> referer);
		$this -> display('member_login');
	}
	public function logout() {
		$synlogout = M('member') -> logout();
		$go = $this -> referer?$this -> referer:ROOT_PATH;
		$this -> showMsg(L('LOGOUT_SUCCESS') . $synlogout, $go);
	}
	public function publish() {
		$this -> obj -> isLogin() or $this -> showMsg(L('LOGIN_FIRST'), Url :: getUrl('member', 'login'));
		$model = 'article';
		$obj = M($model);
		if ($this -> isSubmit) {
			$msg = $obj -> save()?L('OPERATE_SUCCESS'):L('OPERATE_FAIL');
			$this -> showMsg($msg, '?c=member&a=publish&catid=' . intval($_POST['info']['catid']));
		}
		$this -> assign('title', L('PUBLISH'));
		$this -> assign('data', array('catid' => intval(R('catid')), 'title' => '', 'keywords' => ''));
		$this -> assign('member', $this -> obj -> find(get_cookie('userid')));
		$this -> assign('category', Tag :: getObj('category') -> categoryModule($model));
		$this -> display('member_' . $model . '_publish');
	}
	public function published() {
		$this -> obj -> isLogin() or $this -> showMsg(L('LOGIN_FIRST'), Url :: getUrl('member', 'login'));
		$model = 'article';
		$obj = M($model);
		$page = intval(R('page'));
		$where = array('userid' => get_cookie('userid'));
		$this -> assign('data', $obj -> getList($page, 10, $where));
		$this -> assign('pages', $obj -> pages());
		$this -> assign('title', L('PUBLISHED'));
		$this -> assign('member', M('member') -> find(get_cookie('userid')));
		$this -> display('member_' . $model . '_published');
	}
}
