<?php
class RssAction extends Action {
	public function defaults() {
		$rssid = intval(R('rssid'));
		if ($rssid) {
			$data = $item = array();
			$category = Cache::read('category', $rssid);
			$data['title'] = empty($category['seotitle']) ? $category['name'] : $category['seotitle'];
			$data['link'] = htmlentities(Url::getListUrl($rssid), ENT_QUOTES);
			$data['description'] = $category['description'];
			foreach(Tag :: listOne("num=30, catid=$rssid") as $v) {
				$item[] = array('title' => htmlspecialchars_decode($v['title']), 'url' => $v['url'], 'description' => $v['imgurl'] ? "<img src=\"$v[imgurl]\" align=\"left\" />" . $v['description'] : $v['description'], 'author' => $v['username'], 'addtime' => $v['addtime'], 'category' => htmlspecialchars($v['name']));
			}
			$data['item'] = $item;
			Func :: dheader("Content-type: application/xml");
			echo $this -> rss($data);
			exit;
		}
		$catid = intval(R('catid'));
		$this -> assign('catid', $catid);
		$this -> assign('category', get_category($catid));
		$this -> assign('menu', M('category') -> child(0, 0));
		$this -> display('rss');
	}
	private function rss($array) {
		$out = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<rss version=\"2.0\">\r\n  <channel>\r\n    <title>$array[title]</title>\r\n    <link>$array[link]</link>\r\n    <description>$array[description]</description>\r\n    <generator>www.jxcms.com</generator>\r\n    <lastBuildDate>" . gmdate('D, d M Y H:i:s', TIME) . " GMT</lastBuildDate>\r\n    <ttl>60</ttl>\r\n    <image>\r\n      <url>" . ROOT_URL . "images/logo.gif</url>\r\n      <title>" . C('name') . "</title>\r\n      <link>" . ROOT_URL . "</link>\r\n    </image>\r\n";
		foreach($array['item'] as $item) {
			$out .= "    <item>\r\n      <title><![CDATA[$item[title]]]></title>\r\n      <link><![CDATA[$item[url]]]></link>\r\n      <description><![CDATA[$item[description]]]></description>\r\n";
			if (isset($item['category'])) $out .= "      <category>$item[category]</category>\r\n";
			$out .= "      <author>$item[author]</author>\r\n      <pubDate>" . date('Y-m-d H:i:s', $item['addtime']) . "</pubDate>\r\n    </item>\r\n";
		}
		return $out .= "  </channel>\r\n</rss>";
	}
}
