<?php
// ģ
class AdModel extends Model {
	public function save() {
		$info = $_POST['info'];
		$info['id'] = intval($info['id']);
		if (!$info['id']) {
			$info['id'] = $this -> getId('id');
			$info['addtime'] = TIME;
			$isAdd = true;
		} else $isAdd = false;
		$info['endtime'] = Func :: timeStamp($info['endtime']);
		// Ч
		$info['name'] = trim($info['name']);
		if (empty($info['name'])) {
			$this -> error = L('NAME_EMPTY');
			return false;
		}
		if ($info['adtype'] == 'img' || $info['adtype'] == 'flash') {
			$info['width'] = R($info['adtype'] . 'width') > 0 ? R($info['adtype'] . 'width') : 468;
			$info['height'] = R($info['adtype'] . 'height') > 0 ? R($info['adtype'] . 'height') : 60;
		}
		$info['url'] = R($info['adtype'] . 'url');
		$info['content'] = R($info['adtype'] . 'content');
		if (trim($info['content']) == '') {
			$this -> error = L('CONTENT_EMPTY');
			return false;
		}
		$this -> create($info);
		$rs = $isAdd?$this -> add():$this -> update();
		if ($rs) {
			if (in_array($info['adtype'], array('html', 'img', 'flash'))) {
				$attachmentObj = M('attachment', '', $this -> moduleName);
				if ($info['adtype'] == 'html') {
					// ȡϴ
					$attachments = $attachmentObj -> getAttachments($info['content']);
				} else $attachments = array($info['content']);
				$attachmentObj -> setContentId($attachments, $info['id']);
				$attachmentObj -> check($attachments, $info['id']);
			}
		}
		return $rs;
	}
	// ɾ
	public function del() {
		$selids = R('selids');
		if (!empty($selids)) {
			$where = strstr($selids, ',')?"id IN ($selids)":"id=$selids";
			if (!$this -> where($where) -> delete()) {
				$this -> error = L('OPERATE_FAIL');
				$rs = false;
			} else {
				$obj = M('attachment', '', $this -> moduleName);
				$obj -> del(array("module=" . $this -> moduleName, strstr($selids, ',')?"contentid IN ($selids)":"contentid=$selids"));
				$rs = true;
			}
		} else {
			$this -> error = L('NOPARAM');
			$rs = false;
		}
		return $rs;
	}
	// ɹ
	public function makeAdCode($array, $isJS = true) {
		$str = '';
		switch ($array['adtype']) {
			case 'code':
				$str = $array['content'];
				if ($isJS) {
					$str = str_replace('<!--', '', $str);
					$str = str_replace('//-->', '', $str);
					$str = str_replace('-->', '', $str);
				}
				break;
			case 'html':
				$str = Func :: fillDir($array['content']);
				break;
			case 'txt':
				$style = '';
				if (!empty($array['txtfontcolor']))$style .= 'color:' . $array['txtfontcolor'] . ';';
				if ($array['txtfontsize'])$style .= 'font-size:' . $array['txtfontsize'] . 'px;';
				if (!empty($style))$style = " style=\"$style\"";
				$str = "<a href='" . $array['url'] . "' title='" . $array['content'] . "' target='_blank'" . $style . ">" . $array['content'] . "</a>";
				break;
			case 'img':
				$url = strstr($array['content'], '://')?$array['content']:C('APP_DIR', 1, 'root') . $array['content'];
				$str = '<a href="' . $array['url'] . '" title="' . $array['description'] . '" target="_blank"><img src="' . $url . '" width="' . $array['width'] . '" height="' . $array['height'] . '" alt="' . $array['description'] . '" /></a>';
				break;
			case 'flash':
				$url = strstr($array['content'], 'http://')?$array['content']:C('APP_DIR', 1, 'root') . $array['content'];
				$str = "<object classid='clsid:D27CDB6E-AE6D-11cf-96B8-444553540000' codebase='http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0' width='" . $array['width'] . "' height='" . $array['height'] . "'>
  <param name='movie' value='" . $url . "' />
  <param name='quality' value='high' />
  <embed src='" . $url . "' quality='high' pluginspage='http://www.macromedia.com/go/getflashplayer' type='application/x-shockwave-flash' width='" . $array['width'] . "' height='" . $array['height'] . "'></embed>
</object>";
				break;
		}
		return $str;
	}
	public function cache() {
		$ads = $this -> order('id ASC') -> select();
		if (is_array($ads)) {
			$array = array();
			foreach($ads as $ad) {
				$array[$ad['name']] = $ad;
			}
			Cache :: write('ad', $array);
		}
	}
}
