<?php
class RoleModel extends Model {
	public function getList($notCache = true) {
		$array = $this -> order(array('orderid', 'roleid')) -> select();
		if (is_array($array)) {
			if ($notCache) {
				$data = array();
				foreach($array as $v) {
					$v['membernum'] = $this -> table(array('member A', 'member_role B')) -> where(array("B.roleid=$v[roleid]", "A.userid=B.userid")) -> count();
					$data[] = $v;
				}
				return $data;
			}
		}
		return $array;
	}
	// ùԱɫ
	public function set($userid) {
		$userid = intval($userid);
		$this -> setTable('member_role');
		$this -> where("userid=$userid") -> delete();
		$roleids = R('roleids');
		if (!empty($roleids)) {
			foreach($roleids as $roleid) {
				$roleid = intval($roleid);
				if ($roleid) {
					$this -> create(array('userid' => $userid, 'roleid' => $roleid)) -> add();
				}
			}
			$this -> setTable();
			return true;
		}
		return false;
	}
	public function cache() {
		$array = $this -> getList(false);
		$data = array();
		if (is_array($array)) {
			foreach($array as $v) {
				$roleid = $v['roleid'];
				unset($v['orderid']);
				$data[$roleid] = $v;
			}
			Cache :: write('role', $data, '', 'data');
		}
	}
}