<?php
// ģ
class RelatedlinkModel extends Model {
	public function save($isAdd = true) {
		$info = $_POST['info'];
		$info['id'] = intval($info['id']);
		if (!$info['id']) {
			$info['id'] = $this -> getId('id');
			$isAdd = true;
		} else $isAdd = false;
		// Ч
		$info['name'] = trim($info['name']);
		if (empty($info['name'])) {
			$this -> error = L('NAME_EMPTY');
			return false;
		}
		$info['strlens'] = strlen($info['name']);
		if (empty($info['url'])) {
			$this -> error = L('URL_EMPTY');
			return false;
		}
		$this -> create($info);
		return $isAdd?$this -> add():$this -> update();
	}
	public function addMore() {
		$relatedlinks = preg_split("/[\r\n]+/", R('relatedlinks'));
		if (is_array($relatedlinks)) {
			$num = $cnt = 0;
			foreach($relatedlinks as $tmp) {
				$tmp = explode('|', $tmp);
				if (!(empty($tmp[0]) || empty($tmp[1]))) {
					$r = $this -> where("name=$tmp[0]") -> find();
					if (empty($r)) {
						$info = array('name' => $tmp[0],
							'url' => $tmp[1],
							'priority' => isset($tmp[2])?intval($tmp[2]):0,
							'strlens' => strlen($tmp[0]),
							);
						if ($this -> create($info) -> add()) $cnt++ ;
					}
				}
				$num++;
			}
			$r = sprintf(L('ADD_NUM_REAL_NUM'), $num, $cnt);
		} else {
			$this -> error = L('NOPARAM');
			$r = false;
		}
		return $r;
	}
	// ɾ
	public function del() {
		$selids = R('selids');
		if (!empty($selids)) {
			$where = strstr($selids, ',')?"id IN ($selids)":"id=$selids";
			if ($this -> where($where) -> delete()) $r = true;
			else {
				$this -> error = L('OPERATE_FAIL');
				$r = false;
			}
		} else {
			$this -> error = L('NOPARAM');
			$r = false;
		}
		return $r;
	}
	// תе
	private function _base64A($t, $str, $t1) {
		$str = empty($str) ? '' : '{jx_a_base64:' . base64_encode(stripcslashes($str)) . '}';
		return stripcslashes($t) . $str . stripcslashes($t1);
	}
	private function _base64In($t, $str) {
		$str = empty($str) ? '' : '{jx_base64:' . base64_encode(stripcslashes($str)) . '}';
		return stripcslashes($t) . "\"{$str}\"";
	}
	private function _base64Strong($str) {
		return empty($str) ? '' : '<strong>{jx_strong_base64:' . base64_encode(stripcslashes($str)) . '}</strong>';
	}
	// 
	function show($txt, $replacenum = 0, $keywords = '') {
		$txt = preg_replace("/(href\s*=\s*|alt\s*=\s*|title\s*=\s*|src\s*=\s*)[\"|\'](.*?)[\"|\']/ise", "\$this->_base64In('\\1','\\2')", $txt);
		$linkdatas = Cache :: read('relatedlink');
		if ($linkdatas) {
			$txt = preg_replace('/(<a\s.*?>)(.*?)(<\/a>)/ise', "\$this->_base64A('\\1', '\\2', '\\3')", $txt);
			$word1 = $word2 = $replacement = array();
			foreach($linkdatas as $v) {
				$word1[] = '/' . preg_quote($v['name'], '/') . '/';
				$word2[] = $v['name'];
				$replacement[] = '<a href="{jx_base64:' . base64_encode($v['url']) . '}" target="_blank" class="relatedlink">{jx_a_base64:' . base64_encode($v['name']) . '}</a>';
			}
			if ($replacenum > 0) {
				$txt = preg_replace($word1, $replacement, $txt, $replacenum);
			} else {
				$txt = str_replace($word2, $replacement, $txt);
			}
			$txt = preg_replace("/\{jx_a_base64\:(.+?)\}/ise", "base64_decode('\\1')", $txt);
		}
		if ($keywords) {
			$txt = preg_replace('/<strong>(.*?)<\/strong>/ise', "\$this->_base64Strong('\\1')", $txt);
			$keywords = explode(',', $keywords);
			$word1 = $word2 = $replacement = array();
			foreach($keywords as $keyword) {
				$word1[] = '/' . preg_quote($keyword, '/') . '/';
				$word2[] = $keyword;
				$replacement[] = '<strong>{jx_strong_base64:' . base64_encode($keyword) . '}</strong>';
			}
			if ($replacenum > 0) {
				$txt = preg_replace($word1, $replacement, $txt, $replacenum);
			} else {
				$txt = str_replace($word2, $replacement, $txt);
			}
			$txt = preg_replace("/\{jx_strong_base64\:(.+?)\}/ise", "base64_decode('\\1')", $txt);
		}
		$txt = str_replace('</strong><strong>', '', $txt);
		return preg_replace("/\{jx_base64\:(.+?)\}/ise", "base64_decode('\\1')", $txt);
	}
	public function cache() {
		$data = $this -> field(array('name', 'url')) -> order(array('priority DESC', 'strlens DESC', 'id ASC')) -> select();
		if (is_array($data)) {
			Cache :: write('relatedlink', $data);
		}
	}
}
