<?php
final class Url {
	/**
	 * access public
	 *
	 * @param  $module
	 * @param  $action
	 * @param  $forward ֻж̬ʽЧ
	 * @param  $urlModel ַģʽ,˹ָ
	 * @return string
	 */
	public function getUrl($module, $action = '', $forward = '', $urlModel = '', $m = '') {
		$module = get_module($module);
		if ($urlModel === '') $urlModel = defined('IN_ADMIN')?0:C('urlmodel', 0, $module['name']);
		$moduleObj = Tag :: getObj($module['name'], $module['dir']);
		if (method_exists($moduleObj, 'getUrl')) {
			return $moduleObj -> getUrl($action, $forward = '', $urlModel);
		}
		switch ($urlModel) {
			case 1:
				$url = C('htmldir', 0, $module['name']);
				if ($url) $url .= '/';
				$url .= $module['name'];
				if ($m) $url .= C('APP_HTML_LINK', 1) . $m;
				if ($action) $url .= C('APP_HTML_LINK', 1) . $action . C('htmlext');
				break;
			case 2:
				$url = $module['name'];
				if ($m) $url .= C('APP_HTML_LINK', 1) . $m;
				if ($action) $url .= C('APP_HTML_LINK', 1) . $action;
				break;
			default:
				$url = 'index.php?c=' . $module['name'];
				if ($m) $url .= '&m=' . $m;
				if ($action) $url .= '&a=' . $action;
				if ($forward) $url .= '&forward=' . $forward;
				break;
		}
		return ROOT_PATH . $url;
	}
	public function getRssUrl($catid = 0) {
		$urlModel = C('urlmodel', 0, 'rss');
		if ($urlModel == 2) {
			$url .= 'rss' . C('APP_HTML_LINK', 1) . C('APP_HTML_LINK', 1) . $catid;
		} else $url = 'index.php?c=rss&catid=' . $catid;
		return ROOT_PATH . $url;
	}
	public function getXmlUrl($catid = 0) {
		$urlModel = C('urlmodel', 0, 'rss');
		if ($urlModel == 2) {
			$url .= 'xml' . C('APP_HTML_LINK', 1) . $catid;
		} else $url = 'index.php?c=rss&rssid=' . $catid;
		return ROOT_PATH . $url;
	}
	public function getSearchUrl($m = '', $parms = '') {
		if (is_numeric($m)) $m = get_module($m, 'name');
		$searchUrl = ROOT_PATH . 'index.php?a=search';
		$url = array();
		if ($m) $url[] = 'c=' . $m;
		$parms = str_replace(' ', '', $parms);
		if ($parms) {
			$tmp = explode(',', $parms);
			$url = array_merge($url, $tmp);
		}
		if ($url) $searchUrl .= '?' . implode('&', $url);
		return $searchUrl;
	}
	public function getIndexPath() {
		$url = 'index' . C('htmlext');
		return JXCMS_ROOT . MODULE_DIR . $url;
	}
	/**
	 * access public
	 *
	 * @param  $id
	 * @param  $urlModel
	 * @return string
	 */
	public function getOnepageUrl($id, $urlModel = '') {
		if ($urlModel === '') {
			$urlModel = defined('IN_ADMIN')?0:C('urlmodel');
		}
		$data = M('onepage') -> field(array('name')) -> where(array('id' => $id, 'catid' => 0, 'block' => 0)) -> find();
		if (empty($data)) return false;
		switch ($urlModel) {
			case 1:
				$url = C('htmldir');
				if ($url) $url .= '/';
				$url .= $data['name']?$data['name']:'onepage' . C('APP_HTML_LINK', 1) . $id;
				$url .= C('htmlext');
				break;
			case 2:
				$url = $data['name']?$data['name']:'onepage' . C('APP_HTML_LINK', 1) . $id;
				break;
			default:
				$url = 'index.php?c=onepage&id=' . $id;
				break;
		}
		return ROOT_PATH . $url;
	}
	/**
	 * access public
	 *
	 * @param  $module
	 * @param  $id
	 * @return string
	 */
	public function getOnepagePath($id) {
		$urlModel = C('urlmodel');
		if ($urlModel != 1) return false;
		$path = C('htmldir');
		if ($path) $path .= '/';
		$data = M('onepage') -> field(array('name')) -> where(array('id' => $id, 'catid' => 0, 'block' => 0)) -> find();
		$path .= $data['name']?$data['name']:'onepage' . C('APP_HTML_LINK', 1) . $id;
		$path .= C('htmlext', 0, $module['name']);
		return JXCMS_ROOT . MODULE_DIR . $path;
	}
	/**
	 * access public
	 *
	 * @param  $catid
	 * @param  $page
	 * @param  $module
	 * @param  $urlModel
	 * @return string
	 */
	public function getListUrl($catid = 0, $page = 0, $module = '', $urlModel = '') {
		$catid = intval($catid);
		if ($catid) {
			$category = get_category($catid);
			if ($category['type'] == 2) { // ⲿ
				return $category['linkurl'];
			} else {
				if ($category['showmode'] == 3 && $category['subnum']) {
					$category = Tag :: getObj('category') -> categoryChildShow($catid);
				}
				if ($category['type'] == 1) { // ҳ
					// һģ
					$module = array('name' => 'onepage', 'dir' => '', 'state' => 1);
				} else $module = $category['moduleid'];
			}
		}
		if (!is_array($module) && $module)$module = get_module($module);
		if ($urlModel === '') {
			$urlModel = defined('IN_ADMIN')?0:C('urlmodel', 0, $module['name']);
		}
		$moduleObj = Tag :: getObj($module['name'], $module['dir']);
		if (method_exists($moduleObj, 'getListUrl')) {
			return $catid?$moduleObj -> getListUrl($page, $urlModel, $catid, $category['dir']):$moduleObj -> getListUrl($page, $urlModel);
		}
		$entrance = C('list_entrance', 0, $module['name']);
		switch ($urlModel) {
			case 1:
				$url = C('htmldir', 0, $module['name']);
				if ($url) $url .= '/';
				$entrance or $entrance = 'list';
				if ($catid) {
					$url .= $category['dir'];
					if ($category['type'] == 1 && $category['subnum'] == 0) {
						if ($page !== '{page}' && $page < 2) $url .= C('htmlext', 0, $module['name']);
						else {
							$rpos = strrpos($url, '/');
							if ($rpos) {
								$entrance = substr($url, $rpos + 1);
								$url = substr($url, 0, $rpos) . '/';
							} else {
								$entrance = $url;
								$url = '';
							}
						}
					} else $url .= '/';
				} else $url .= $module['name'] . '/';
				if ($page > 1 || $page === '{page}') $url .= $entrance . C('APP_HTML_LINK', 1) . $page . C('htmlext', 0, $module['name']);
				break;
			case 2:
				$entrance or $entrance = 'list';
				$url = $catid?$entrance . C('APP_HTML_LINK', 1) . $catid:$module['name'] . C('APP_HTML_LINK', 1) . $entrance;
				if ($page !== '{page}' && $page < 1)$page = 1;
				$url .= C('APP_HTML_LINK', 1) . $page;
				break;
			default:
				$entrance or $entrance = 'index';
				$url = $entrance . '.php?a=list&';
				$url .= $catid?'catid=' . $catid:'c=' . $module['name'];
				if ($page > 1 || $page === '{page}') $url .= '&page=' . $page;
				break;
		}
		return ROOT_PATH . $url;
	}
	/**
	 * access public
	 *
	 * @param  $catid
	 * @param  $page
	 * @param  $module
	 * @return string
	 */
	public function getListPath($catid = 0, $page = 0, $module = '') {
		$catid = intval($catid);
		if ($catid) {
			$category = get_category($catid);
			// ⲿ
			if ($category['type'] == 2) {
				return false;
			} else {
				if ($category['showmode'] == 3 && $category['subnum']) {
					$category = Tag :: getObj('category') -> categoryChildShow($catid);
				}
				if ($category['type'] == 1) { // ҳ
					// һģ
					$module = array('name' => 'onepage', 'dir' => '', 'state' => 1);
				} else {
					$module = $category['moduleid'];
					$module = get_module($module);
				}
			}
		}
		if (empty($module)) return false;
		$urlModel = C('urlmodel', 0, $module['name']);
		if ($urlModel != 1) return false;
		$moduleObj = Tag :: getObj($module['name'], $module['dir']);
		if (method_exists($moduleObj, 'getListPath')) {
			return $catid?$moduleObj -> getListPath($page, $catid):$moduleObj -> getListPath($page);
		}
		$entrance = C('list_entrance', 0, $module['name'])?C('list_entrance', 0, $module['name']):'list';
		$url = C('htmldir', 0, $module['name']);
		if ($url) $url .= '/';
		if ($catid) {
			$url .= $category['dir'];
			if ($category['type'] == 1 && $category['subnum'] == 0) {
				if ($page < 2) $url .= C('htmlext', 0, $module['name']);
				else {
					$rpos = strrpos($url, '/');
					if ($rpos) {
						$entrance = substr($url, $rpos + 1);
						$url = substr($url, 0, $rpos) . '/';
					} else {
						$entrance = $url;
						$url = '';
					}
				}
			} elseif ($page < 2) {
				$url .= '/index' . C('htmlext', 0, $module['name']);
			} else {
				$url .= '/';
			}
		}
		if ($page > 1) $url .= $entrance . C('APP_HTML_LINK', 1) . $page . C('htmlext', 0, $module['name']);
		if (empty($url)) return false;
		return JXCMS_ROOT . MODULE_DIR . $url;
	}
	private function _getContentField($id) {
		if (strstr($id, '=')) {
			$tmp = explode('=', $id);
			$id = intval($tmp[1]);
			$field = $tmp[0];
		} else $id = intval($id);
		if (empty($field)) $field = 'id';
		return array('id' => $id, 'field' => $field);
	}
	/**
	 * access public
	 *
	 * @param  $module
	 * @param  $id
	 * @param  $page
	 * @param  $urlModel
	 * @return string
	 */
	public function getContentUrl($module, $id, $page = 0, $urlModel = '', $action = '') {
		$tmp = self :: _getContentField($id);
		$id = $tmp['id'];
		$field = $tmp['field'];
		$module = get_module($module);
		if ($urlModel === '') {
			$urlModel = defined('IN_ADMIN')?0:C('urlmodel', 0, $module['name']);
		}
		$moduleObj = Tag :: getObj($module['name'], $module['dir']);
		if (method_exists($moduleObj, 'getContentUrl')) {
			return $moduleObj -> getContentUrl($id, $page, $urlModel, $action);
		}
		switch ($urlModel) {
			case 1:
				$url = self :: _ContentPath($module, $id, $moduleObj, $page);
				break;
			case 2:
				if (!C('user_defined_url', 0, $module['name'])) {
					$entrance = C('content_entrance', 0, $module['name'])?C('content_entrance', 0, $module['name']):$module['name'];
					$url = $entrance . C('APP_HTML_LINK', 1) . $id;
					if ($action) $url = $action . C('APP_HTML_LINK', 1) . $url;
					if ($page > 1 || $page === '{page}') $url .= C('APP_HTML_LINK', 1) . $page;
					$url .= C('htmlext', 0, $module['name']);
				} else $url = self :: _ContentPath($module, $id, $moduleObj, $page);
				break;
			default:
				$entrance = C('content_entrance', 0, $module['name']);
				$url = $entrance?$entrance . '.php?':'index.php?c=' . $module['name'] . '&';
				if ($action) $url .= 'a=' . $action . '&';
				$url .= $field . '=' . $id;
				if ($page > 1 || $page === '{page}') $url .= '&page=' . $page;
				break;
		}
		return ROOT_PATH . $url;
	}
	/**
	 * access public
	 *
	 * @param  $module
	 * @param  $id
	 * @return string
	 */
	public function getContentPath($module, $id, $page = 0) {
		$tmp = self :: _getContentField($id);
		$id = $tmp['id'];
		$field = $tmp['field'];
		$module = get_module($module);
		$urlModel = C('urlmodel', 0, $module['name']);
		if ($urlModel != 1) return false;
		$moduleObj = Tag :: getObj($module['name'], $module['dir']);
		if (method_exists($moduleObj, 'getContentPath')) {
			return $moduleObj -> getContentPath($id, $page);
		}
		$path = self :: _ContentPath($module, $id, $moduleObj, $page);
		return $path?JXCMS_ROOT . MODULE_DIR . $path:'';
	}
	private function _ContentPath($module, $id, $moduleObj, $page) {
		$url = C('htmldir', 0, $module['name']);
		if ($url) $url .= '/';
		$contrule = C('contrule', 0, $module['name']);
		$data = $moduleObj -> find($id);
		if (empty($data)) return false;
		isset($data['addtime']) && $addTime = $data['addtime'];
		empty($data['filename']) or $id = $data['filename'];
		if (isset($data['catid'])) {
			$category = get_category($data['catid']);
			$catDir = isset($category['dir'])?$category['dir']:'';
			$categoryDir = explode('/', $category['dir']);
		}
		if ($contrule) {
			if (strstr($contrule, '{catdir')) {
				if (strstr($contrule, '{catdir}')) {
					isset($catDir) or $catDir = '';
					$contrule = str_replace('{catdir}', $catDir, $contrule);
				}
				if (strstr($contrule, '{catdir1}')) {
					$tmp = isset($categoryDir[0])?$categoryDir[0]:'';
					$contrule = str_replace('{catdir1}', $tmp, $contrule);
				}
				$catDir2 = isset($categoryDir[1])?$categoryDir[0] . '/' . $categoryDir[1]:$categoryDir[0];
				if (strstr($contrule, '{catdir2}'))$contrule = str_replace('{catdir2}', $catDir2, $contrule);
				$catDir3 = isset($categoryDir[2])?$categoryDir[0] . '/' . $categoryDir[1] . '/' . $categoryDir[2]:$catDir2;
				if (strstr($contrule, '{catdir3}'))$contrule = str_replace('{catdir3}', $catDir3, $contrule);
			}
			$contrule = str_replace('{y}', date('Y', $addTime), $contrule);
			$contrule = str_replace('{m}', date('m', $addTime), $contrule);
			$contrule = str_replace('{d}', date('d', $addTime), $contrule);
			$contrule = str_replace('{timestamp}', $addTime, $contrule);
			$contrule = str_replace('{module}', $module['name'], $contrule);
			$contrule = str_replace('{id}', $id, $contrule);
			if (substr($contrule, 0, 1) == '/') $contrule = substr($contrule, 1);
			while (strstr($contrule, '//')) $contrule = str_replace('//', '/', $contrule);
		} else {
			$contrule = isset($categoryDir[0])?$categoryDir[0] . '/':'';
			$contrule .= C('content_entrance', 0, $module['name'])?C('content_entrance', 0, $module['name']):$module['name'];
		}
		if ($page > 1 || $page === '{page}') $contrule .= C('APP_HTML_LINK', 1) . $page;
		return $url . $contrule . C('htmlext', 0, $module['name']);
	}
}
