<?php
final class Validate {
	/**
	 * ʱڣ GNU Date Input Formats yyyy/mm/ddyyyy-mm-ddhh:mm:ss
	 */
	function isDateTime($value) {
		return preg_match('/^[yY]-[mn]-[dj]$/is', $value) != 0;
	}

	/**
	 * ҳ
	 */
	function isPage($page) {
		return !empty($page) && preg_match('/^([0-9]+)$/', $page);
	}

	function isUrl($url) {
		return preg_match('/(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*(\\?\\S*)?/', $url);
	}

	/**
	 * 
	 */
	function isDOMAIN($value) {
		return preg_match('/[a-z0-9\.]/is', $value) != 0;
	}

	/**
	 * ɫ
	 */
	function isColorCode($value) {
		return preg_match('/^#[0-9a-f]{6}/i', $value) != 0;
	}

	/**
	 * 
	 */
	function isINT($value) {
		return strlen(intval($value)) == strlen($value) && is_numeric($value);
	}

	/**
	 * ʼ
	 *
	 * @param String $email ʼַ
	 */
	function checkEmail($email) {
		return preg_match('/^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,3}$/i', $email);
	}

	/**
	 * QQǷϷ
	 */
	function checkQQ($qq) {
		return preg_match('/^[1-9][0-9]{4,12}$/i', $qq);
	}

	/**
	 * MSNǷϷ
	 */
	function checkMSN($msn) {
		return preg_match('/^[_\.0-9a-zA-Z-]+@[\w\.]*?$/i', $msn);
	}
}
