<?php
define('IN_JXCMS', true);
define('UC_CLIENT_VERSION', '1.6.0');//UCenter 汾ʶ
define('UC_CLIENT_RELEASE', '20110501');

define('API_DELETEUSER', 1);//ûɾ API ӿڿ
define('API_RENAMEUSER', 0);//û API ӿڿ
define('API_GETTAG', 1);//ȡǩ API ӿڿ
define('API_SYNLOGIN', 1);//ͬ¼ API ӿڿ
define('API_SYNLOGOUT', 1);//ͬǳ API ӿڿ
define('API_UPDATEPW', 1);//û 
define('API_UPDATEBADWORDS', 1);//¹ؼб 
define('API_UPDATEHOSTS', 1);// 
define('API_UPDATEAPPS', 1);//Ӧб 
define('API_UPDATECLIENT', 1);//¿ͻ˻ 
define('API_UPDATECREDIT', 1);//û 
define('API_GETCREDIT', 1);//ȡûĳ 
define('API_GETCREDITSETTINGS', 1);// UCenter ṩ 
define('API_UPDATECREDITSETTINGS', 1);//Ӧû 
define('API_ADDFEED', 1);
define('API_RETURN_SUCCEED', '1');
define('API_RETURN_FAILED', '-1');
define('API_RETURN_FORBIDDEN', '-2');

define('IN_API', true);
define('CURSCRIPT', 'api');

// ͨ http ֪ͨʽ
if (!defined('IN_UC')) {
	error_reporting(0);
	set_magic_quotes_runtime(0);
	defined('MAGIC_QUOTES_GPC') or define('MAGIC_QUOTES_GPC', get_magic_quotes_gpc());
	include dirname(__FILE__) . '/../jxcms/common.php';
	include_once JXCMS_ROOT . 'uc_client/config.php';
	$_DCACHE = $get = $post = array();

	$code = R('code', 'get');
	parse_str(_authcode($code, 'DECODE', UC_KEY), $get);
	if (MAGIC_QUOTES_GPC) {
		$get = _stripslashes($get);
	}

	if (TIME - $get['time'] > 3600) {
		exit('Authracation has expiried');
	}
	if (empty($get)) {
		exit('Invalid Request');
	}
	$action = $get['action'];

	include JXCMS_ROOT . 'uc_client/lib/xml.class.php';
	$post = xml_unserialize(file_get_contents('php://input'));

	if (in_array($get['action'], array('test', 'deleteuser', 'renameuser', 'gettag', 'synlogin', 'synlogout', 'updatepw', 'updatebadwords', 'updatehosts', 'updateapps', 'updateclient', 'updatecredit', 'getcreditsettings', 'updatecreditsettings'))) {
		$uc_note = new uc_note();
		exit($uc_note -> $get['action']($get, $post));
	} else {
		exit(API_RETURN_FAILED);
	}
} else {
	exit;
}

class uc_note {
	public $member = '';
	public function __construct() {
		$this -> member = M('member');
	}
	public function _serialize($arr, $htmlon = 0) {
		if (!function_exists('xml_serialize')) {
			include_once JXCMS_ROOT . 'uc_client/lib/xml.class.php';
		}
		return xml_serialize($arr, $htmlon);
	}

	public function test($get, $post) {
		return API_RETURN_SUCCEED;
	}

	public function deleteuser($get, $post) {
		$uids = str_replace("'", '', stripslashes($get['ids']));
		API_DELETEUSER or exit(API_RETURN_FORBIDDEN);
		$this -> member -> where("userid IN ($uids)") -> delete();
		return API_RETURN_SUCCEED;
	}

	public function synlogin($get, $post) {
		if (!API_SYNLOGIN) {
			return API_RETURN_FORBIDDEN;
		}
		$userinfo = $this -> member -> field(array('userid', 'username', 'password', 'groupid', 'email', 'lastdate')) -> where('username=' . $get['username']) -> find();
		$this -> member -> setLogin($userinfo);
		header('P3P: CP="CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR"');
	}

	public function synlogout($get, $post) {
		if (!API_SYNLOGOUT) {
			return API_RETURN_FORBIDDEN;
		}
		// ͬǳ API ӿ
		header('P3P: CP="CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR"');
		$this -> member -> setLogout();
	}

	public function updatepw($get, $post) {
		if (!API_UPDATEPW) {
			return API_RETURN_FORBIDDEN;
		}
		$this -> member -> setFields(array('password' => md5(TIME)), 'username', $get['username']);
		return API_RETURN_SUCCEED;
	}

	public function updatebadwords($get, $post) {
		if (!API_UPDATEBADWORDS) {
			return API_RETURN_FORBIDDEN;
		}
		$cachefile = JXCMS_ROOT . 'uc_client/data/cache/badwords.php';
		$fp = fopen($cachefile, 'w');
		$data = array();
		if (is_array($post)) {
			foreach($post as $k => $v) {
				$data['findpattern'][$k] = $v['findpattern'];
				$data['replace'][$k] = $v['replacement'];
			}
		}
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'badwords\'] = ' . var_export($data, true) . ";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		return API_RETURN_SUCCEED;
	}

	public function updatehosts($get, $post) {
		if (!API_UPDATEHOSTS) {
			return API_RETURN_FORBIDDEN;
		}
		$cachefile = JXCMS_ROOT . 'uc_client/data/cache/hosts.php';
		$fp = fopen($cachefile, 'w');
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'hosts\'] = ' . var_export($post, true) . ";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		return API_RETURN_SUCCEED;
	}

	public function updateapps($get, $post) {
		if (!API_UPDATEAPPS) {
			return API_RETURN_FORBIDDEN;
		}
		$UC_API = $post['UC_API'];
		// д app ļ
		$cachefile = JXCMS_ROOT . 'uc_client/data/cache/apps.php';
		$fp = fopen($cachefile, 'w');
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'apps\'] = ' . var_export($post, true) . ";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		// дļ
		$jx_cofig_file = JXCMS_ROOT . 'uc_client/config.php';
		if (is_writeable($jx_cofig_file)) {
			$configfile = trim(file_get_contents($jx_cofig_file));
			$configfile = preg_replace("/define\('UC_API',\s*'.*?'\);/i", "define('UC_API', '$UC_API');", $configfile);
			if ($fp = @fopen($jx_cofig_file, 'w')) {
				@fwrite($fp, trim($configfile));
				@fclose($fp);
			}
		}

		return API_RETURN_SUCCEED;
	}

	public function updateclient($get, $post) {
		if (!API_UPDATECLIENT) {
			return API_RETURN_FORBIDDEN;
		}
		$cachefile = JXCMS_ROOT . 'uc_client/data/cache/settings.php';
		$fp = fopen($cachefile, 'w');
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'settings\'] = ' . var_export($post, true) . ";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		return API_RETURN_SUCCEED;
	}

	public function updatecredit($get, $post) {
		if (!API_UPDATECREDIT) {
			return API_RETURN_FORBIDDEN;
		}
		$userid = intval($get['uid']);
		$credit = intval($get['credit']);
		$creditvar = array(1 => 'point', 2 => 'amount');
		$this -> member -> setFields(array($creditvar[$credit] => $creditvar[$credit] + $get['amount']), 'userid', $userid);
		return API_RETURN_SUCCEED;
	}

	public function getcredit($get, $post) {
		if (!API_GETCREDIT) {
			return API_RETURN_FORBIDDEN;
		}
		$userid = intval($get['uid']);
		$credit = intval($get['credit']);
		$creditvar = array(1 => 'point', 2 => 'amount');
		return $this -> member -> field($creditvar[$credit]) -> find($userid);
	}

	public function getcreditsettings($get, $post) {
		if (!API_GETCREDITSETTINGS) {
			return API_RETURN_FORBIDDEN;
		}
		$credits = array(1 => array('', ''), 2 => array('Ǯ', 'Ԫ'),);
		return $this -> _serialize($credits);
	}

	public function updatecreditsettings($get, $post) {
		if (!API_UPDATECREDITSETTINGS) {
			return API_RETURN_FORBIDDEN;
		}
		return API_RETURN_SUCCEED;
	}
}

function _setcookie($var, $value, $life = 0, $prefix = 1) {
	setcookie(($prefix ? C('COOKIE_PRE', 1) : '') . $var, $value,
		$life ? TIME + $life : 0, C('COOKIE_PATH', 1),
		C('COOKIE_DOMAIN', 1), $_SERVER['SERVER_PORT'] == 443 ? 1 : 0);
}

function _authcode($string, $operation = 'DECODE', $key = '', $expiry = 0) {
	$ckey_length = 4;

	$key = md5($key ? $key : UC_KEY);
	$keya = md5(substr($key, 0, 16));
	$keyb = md5(substr($key, 16, 16));
	$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), - $ckey_length)) : '';

	$cryptkey = $keya . md5($keya . $keyc);
	$key_length = strlen($cryptkey);

	$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0) . substr(md5($string . $keyb), 0, 16) . $string;
	$string_length = strlen($string);

	$result = '';
	$box = range(0, 255);

	$rndkey = array();
	for($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($cryptkey[$i % $key_length]);
	}

	for($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $box[$i] + $rndkey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}

	for($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}

	if ($operation == 'DECODE') {
		if ((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26) . $keyb), 0, 16)) {
			return substr($result, 26);
		} else {
			return '';
		}
	} else {
		return $keyc . str_replace('=', '', base64_encode($result));
	}
}

function _stripslashes($string) {
	if (is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = _stripslashes($val);
		}
	} else {
		$string = stripslashes($string);
	}
	return $string;
}
