<?php
class Model {
	protected $tablePrefix = ''; // ݱǰ׺
	protected $tableName = ''; // ݱ(ǰ׺)
	protected $defaultTableName = ''; //Ĭݱ(ǰ׺)
	protected $moduleName = ''; // ǰģ
	protected $dbConfigDir = ''; // ݿĿ¼,ģʹöݿʱʹ
	protected $cacheFields = array(); // ֶϢ
	protected $options = array(); // ѯʽ
	public $data = array(); // Ϣ
	public $error = ''; // Ϣ
	public $totle = 0; //
	public $startNo = 1; //ʾ :2ҳʼҪǰ
	public $validate = array(); // ֤
	public $page = 1;
	public $pageSize = 20;
	/**
	 * ܹ
	 * ȡDBʵ ֶμ
	 *
	 * @param  $tableName
	 * @access public
	 */
	public function __construct($init = '') {
		// ģͳʼ
		if (method_exists($this, '_initialize')) $this -> _initialize($init);
		// ñǰ׺
		$this -> tablePrefix = C('DB_PREFIX', 1);
		if (empty($this -> moduleName)) {
			$className = get_class($this);
			if ($className == 'Model') $className = $init;
			$className = substr($className, 0, -5);
			$this -> moduleName = $className?$className:'Model';
		}
		if (empty($this -> tableName)) {
			if (empty($this -> defaultTableName)) $this -> defaultTableName = parse_name($this -> moduleName);
			$this -> tableName = $this -> defaultTableName;
		}
	}
	/**
	 * õǰݱ,һ㲻ڲѯʹ
	 *
	 * @param  $tableName Ϊʱ,ָĬֵ
	 * @access public
	 */
	public function setTable($tableName = '') {
		$this -> tableName = $tableName?$tableName:$this -> defaultTableName;
		return $this;
	}
	/**
	 * DB
	 *
	 * @access public
	 * @param void $
	 * @return object
	 */
	public function db() {
		return Db :: getInitial($this -> dbConfigDir);
	}
	/**
	 * лݿĿ¼
	 *
	 * @access public
	 * @param void $dbConfigDir ģʹöݿʱʹ
	 * @return object
	 */
	public function setDbConfigDir($dbConfigDir = '') {
		$this -> dbConfigDir = $dbConfigDir;
		$this -> tablePrefix = C('DB_PREFIX', 1, $dbConfigDir);
		return $this;
	}
	/**
	 * ݶֵ
	 *
	 * @access public
	 * @param string $name 
	 * @param mixed $value ֵ
	 * @return void
	 */
	public function __set($name, $value) {
		// ݶ
		$this -> data[$name] = $value;
	}

	/**
	 * ȡݶֵ
	 *
	 * @access public
	 * @param string $name 
	 * @return mixed
	 */
	public function __get($name) {
		return isset($this -> data[$name])?$this -> data[$name]:null;
	}

	/**
	 * ݶֵ
	 *
	 * @access public
	 * @param string $name 
	 * @return boolean
	 */
	public function __isset($name) {
		return isset($this -> data[$name]);
	}

	/**
	 * ݶֵ
	 *
	 * @access public
	 * @param string $name 
	 * @return void
	 */
	public function __unset($name) {
		unset($this -> data[$name]);
	}

	/**
	 * __callʵһЩModel
	 *
	 * @access public
	 * @param string $method 
	 * @param array $args ò
	 * @return mixed
	 */
	public function __call($method, $args) {
		$method = strtolower($method);
		if (in_array($method, array('field', 'table', 'where', 'order', 'limit', 'page', 'having', 'group', 'lock', 'distinct'), true)) {
			// ʵ
			$this -> options[$method] = $args[0];
			return $this;
		} elseif (in_array($method, array('count', 'sum', 'min', 'max', 'avg'), true)) {
			// ͳƲѯʵ
			$field = isset($args[0])?$args[0]:'*';
			$r = $this -> field(strtoupper($method) . '(' . $field . ') AS tp') -> find();
			return $r['tp'];
		} else {
			show_error(__CLASS__ . ':' . $method . L('METHOD_NOT_EXIST'));
		}
	}
	/**
	 * ѯSQLװ join
	 *
	 * @access public
	 * @param string $table
	 * @param string $on
	 * @param string $type
	 * @return Object
	 */
	public function join($table, $on, $type = 'left') {
		if ($table && $on) {
			$table = $this -> getTableName($table);
			$this -> options['join'][] = array($table, $on, $type);
		}
		return $this;
	}

	/**
	 * ѯSQLװ union
	 *
	 * @access public
	 * @param mixed $union
	 * @param boolean $all
	 * @return Object
	 */
	public function union($union, $all = false) {
		if (empty($union)) return $this;
		if ($all) {
			$this -> options['union']['_all'] = true;
		}
		// תunionʽ
		if (is_string($union)) {
			$options = $union;
		} elseif (is_array($union)) {
			if (isset($union[0])) {
				$this -> options['union'] = array_merge($this -> options['union'], $union);
				return $this;
			} else {
				$options = $union;
			}
		} else {
			show_error(L('DATA_TYPE_INVALID'));
		}
		$this -> options['union'][] = $options;
		return $this;
	}
	/**
	 * SQLѯ
	 *
	 * @access public
	 * @param mixed $sql SQLָ
	 * @return mixed
	 */
	public function query($sql) {
		if ($sql) {
			if (strpos($sql, '__TABLE__')) $sql = str_replace('__TABLE__', $this -> getTableName(), $sql);
			return $this -> db() -> query($sql);
		}
		return false;
	}
	/**
	 * 
	 *
	 * @access public
	 * @param boolean $replace Ƿreplace
	 * @return mixed
	 */
	public function add($replace = false) {
		if (empty($this -> data)) return false;
		if (!empty($this -> options['table'])) {
			$backTableName = $this -> tableName;
			$this -> setTable($this -> options['table']);
		}
		// ʽ
		$options = $this -> parseOptions();
		// дݵݿ
		$result = $this -> db() -> insert($this -> data, $options, $replace);
		if (false !== $result) {
			$insertId = $this -> getInsertId();
			if ($insertId) {
				$this -> data[$this -> getPk()] = $insertId;
				$result = $insertId; // زID
			}
		}
		if (isset($backTableName)) $this -> setTable($backTableName);
		return $result;
	}
	/**
	 * 
	 *
	 * @access public
	 * @return boolean
	 */
	public function update() {
		if (empty($this -> data)) return false;
		if (!empty($this -> options['table'])) {
			$backTableName = $this -> tableName;
			$this -> setTable($this -> options['table']);
		}
		// ʽ
		$options = $this -> parseOptions();
		if (!isset($options['where'])) {
			//  ԶΪ
			$pk = $this -> getPk();
			if (isset($this -> data[$pk])) {
				$pkValue = $this -> data[$pk];
				$options['where'] = $pk . '=' . $pkValue;
				unset($this -> data[$pk]);
			} else {
				// ûκθִ
				$this -> error = L('OPERATION_WRONG');
				return false;
			}
		}
		$result = $this -> db() -> update($this -> data, $options);
		if (false !== $result && isset($pkValue)) $this -> data[$pk] = $pkValue;
		if (isset($backTableName)) $this -> setTable($backTableName);
		return $result;
	}
	/**
	 * 
	 *
	 * @access public
	 * @param mixed $data
	 * @return mixed
	 */
	public function create($data = '') {
		// ûдֵĬȡPOST
		if (empty($data)) $data = $_POST;
		elseif (is_object($data)) $data = get_object_vars($data);
		elseif (!is_array($data)) {
			$this -> error = L('DATA_TYPE_INVALID');
			return false;
		}
		// ֤
		if (!$this -> autoCheckToken($data)) {
			$this -> error = L('TOKEN_ERROR');
			return false;
		}
		// ֤
		if (!$this -> validation($data)) return false;
		// ֤ݶ
		$vo = array();
		$dbFieldTypeCheck = C('DB_FIELDTYPE_CHECK', 1);
		foreach ($this -> getFields() as $name => $field) {
			$val = isset($data[$name])?$data[$name]:null;
			if ($dbFieldTypeCheck && is_scalar($val) && substr($val, 0, strlen($name)) != $name) {
				// ֶͼ
				if (false !== strpos($field['type'], 'int'))
					$val = intval($val);
				elseif (false !== strpos($field['type'], 'float') || false !== strpos($field['type'], 'double'))
					$val = floatval($val);
			}
			// ֵ֤Ч
			if (!is_null($val)) $vo[$name] = (MAGIC_QUOTES_GPC && is_string($val))?stripslashes($val):$val;
		}
		$this -> data = $vo;
		return $this;
	}
	/**
	 * ʽ
	 *
	 * @access private
	 * @param mix $options
	 * @return array
	 */
	private function parseOptions($options = array()) {
		if (empty($options)) $options = array();
		elseif (is_numeric($options) || is_string($options)) {
			$options = array('where' => $this -> getPk() . '=' . $options);
		}
		$options = array_merge($this -> options, $options);
		// ѯsqlʽװ Ӱ´βѯ
		$this -> options = array();
		// Զȡ
		$options['table'] = isset($options['table'])?$this -> getTableName($options['table']):$this -> getTableName();
		return $options;
	}
	/**
	 * ѯݼ
	 *
	 * @access public
	 * @param string $condition
	 * @return mixed
	 */
	public function select($condition = '') {
		// ʽ
		$options = $this -> parseOptions($condition);
		if (isset($options['page'])) {
			$listRows = isset($options['limit'])?intval($options['limit']):0;
			if ($listRows) $this -> pageSize = $listRows;
			$field = isset($options['field'])?$options['field']:'*'; //ֶ
			$options['limit'] = 1;
			$options['field'] = 'COUNT(*) AS cnt';
			$t = $this -> db() -> select($options);
			$this -> totle = $t['cnt'];
			// ҳlimit
			if ($listRows < 1) $listRows = 20; //ñpagesĬֵһ£·ҳ
			$pages = ceil($this -> totle / $listRows);
			$page = max(min($pages, intval($options['page'])), 1);
			if (defined('IN_CREATEHTML') && $pages > 1 && $page == 1) {
				Cache :: write('createHtmlPages', array('pages' => $pages));
			}
			$offset = $listRows * ($page-1);
			$this -> startNo = $offset + 1;
			$options['limit'] = $offset . ', ' . $listRows;
			$options['field'] = $field; // ԭֶ
		}
		$r = $this -> db() -> select($options);
		if (false === $r) return false;
		if (empty($r)) return null; // ѯΪ
		return $r;
	}
	/**
	 * ɾ
	 *
	 * @access public
	 * @param string $ / num $condition
	 * @return mixed
	 */
	public function delete($condition = '') {
		if (empty($condition) && empty($this -> options)) {
			// ɾΪ ɾǰݶӦļ¼
			if (!empty($this -> data) && isset($this -> data[$this -> getPk()]))
				return $this -> delete($this -> data[$this -> getPk()]);
			else
				return false;
		}
		// ʽ
		$options = $this -> parseOptions($condition);
		return $this -> db() -> delete($options);
	}
	/**
	 * ѯ
	 *
	 * @access public
	 * @param string $ or num $condition ʽ
	 * @return mixed
	 */
	public function find($condition = '') {
		// ʽ
		$options = $this -> parseOptions($condition);
		// ǲһ¼
		$options['limit'] = 1;
		$result = $this -> db() -> select($options);
		if (false === $result) return false;
		if (empty($result)) return null; // ѯΪ
		return $result;
	}
	// Զ֤
	public function autoCheckToken($data) {
		$name = C('TOKEN_NAME', 1);
		if (isset($data[$name])) {
			isset($_SESSION) or session_start();
			$index = $name . substr($data[$name], 0, 4);
			$index = strtoupper($index);
			if (isset($_SESSION[$index])) {
				// ǰҪ֤
				if (empty($data[$name]) || $_SESSION[$index] != $data[$name]) return false; // Ƿύ
				// ֤session
				unset($_SESSION[$index]);
				return true;
			}
			return false;
		}
		return true;
	}
	/**
	 * ȡֶϢ
	 *
	 * @access public
	 * @return void
	 */
	protected function getFields() {
		$tableName = $this -> getTableName(empty($this -> options['table'])?'':$this -> options['table']);
		if (!isset($this -> cacheFields[$tableName])) {
			$this -> cacheFields[$tableName] = Cache :: read($tableName, '', 0, 'Fields');
			if (false === $this -> cacheFields[$tableName]) {
				// 治ѯݱϢ
				$this -> cacheFields[$tableName] = $this -> db() -> getFields($tableName);
				// ݱ
				if (C('DB_FIELDS_CACHE', 1)) Cache :: write($tableName, $this -> cacheFields[$tableName], '', 'Fields');
			}
		}
		return $this -> cacheFields[$tableName];
	}
	/**
	 * õݱ
	 *
	 * @access public
	 * @return string
	 */
	public function getTableName($tableName = '') {
		if (empty($tableName)) $tableName = $this -> tableName;
		if (is_array($tableName)) {
			$array = array();
			foreach($tableName as $tmp) {
				$array[] = substr($tmp, 0, 1) == '@'?substr($tmp, 1):$this -> tablePrefix . $tmp;
			}
			return $array;
		}
		return substr($tableName, 0, 1) == '@'?substr($tmp, 1):$this -> tablePrefix . $tableName;
	}
	/**
	 * ɾ
	 *
	 * @access public
	 * @return boolean
	 */
	public function del($selids = 0) {
		$selids or $selids = R('selids');
		if (!empty($selids)) {
			if (is_array($selids)) $selids = implode(', ', $selids);
			$pk = $this -> getPk();
			$where = strstr($selids, ',')?"$pk IN ($selids)":"$pk=$selids";
			if (!$this -> where($where) -> delete()) {
				$this -> error = L('OPERATE_FAIL');
				$rs = false;
			} else $rs = true;
		} else {
			$this -> error = L('NOPARAM');
			$rs = false;
		}
		return $rs;
	}
	/**
	 * ȡ
	 *
	 * @access public
	 * @return string
	 */
	public function getPk() {
		$fields = $this -> getFields();
		if (is_array($fields)) foreach($fields as $field) {
			if ($field['primary']) return $field['name'];
		}
		return 'id';
	}
	/**
	 * ID
	 *
	 * @access public
	 * @return string
	 */
	public function getInsertId() {
		return $this -> db() -> insertId();
	}
	/**
	 * Ӱļ¼
	 *
	 * @access public
	 * @return num
	 */
	public function getAffectedRows() {
		return $this -> db() -> affectedRows();
	}
	/**
	 * ִеsql
	 *
	 * @access public
	 * @return string
	 */
	public function getLastSql() {
		return $this -> db() -> getLastSql();
	}
	/**
	 * ֤
	 *
	 * @access protected
	 * @param array $data 
	 * @param string $type 
	 * @return boolean
	 */
	protected function validation($data) {
		// ֤
		if (!empty($this -> validate)) {
			$this -> error = '';
			// ֤,֤
			foreach($this -> validate as $val) {
				// $val ʽ array(field,message,rule)
				// жǷҪִ֤
				if (substr($val[2], 0, 1) === '/' && substr($val[2], -1) === '/') {
					if (!$this -> regex($data[$val[0]], $val[2])) $this -> error = $val[1];
				} elseif (method_exists($this, $val[2])) {
					if (!call_user_func(array(&$this, $val[2]), $data[$val[0]])) $this -> error = $val[1];
				} elseif (function_exists($val[2])) {
					if (!call_user_func($val[2], $data[$val[0]])) $this -> error = $val[1];
				} elseif (strstr($val[0], ',')) {
					$val[0] = str_replace(' ', '', $val[0]);
					$fields = explode(',', $val[0]);
					if (!$this -> comput($fields[0], $fields[1], $val[2], $data)) $this -> error = $val[1];
				} elseif (!$this -> regex($data[$val[0]], $val[2])) $this -> error = $val[1];
				if ($this -> error) return false;
			}
		}
		return true;
	}
	/**
	 * ʽ
	 *
	 * @access private
	 * @param array $options ʽ
	 * @return array
	 */
	private function comput($field1, $field2, $logic = '=', $data) {
		if (!in_array($logic, array('=', '!=', '>', '>=', '<', '<='))) $logic = '=';
		if (isset($data[$field1])) $field1 = $data[$field1];
		if (isset($data[$field2])) $field2 = $data[$field2];
		if ($logic == '=') return $field1 == $field2;
		if ($logic == '!=') return $field1 != $field2;
		if ($logic == '>') return $field1 > $field2;
		if ($logic == '>=') return $field1 > $field2;
		if ($logic == '<') return $field1 < $field2;
		if ($logic == '<=') return $field1 <= $field2;
	}
	/**
	 * ʹ֤
	 *
	 * @access public
	 * @param string $value Ҫ֤
	 * @param string $rule ֤
	 * @return boolean
	 */
	public function regex($value, $rule) {
		$validate = array('require' => '/.+/',
			'email' => '/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/',
			'url' => '/^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/',
			'currency' => '/^\d+(\.\d+)?$/',
			'number' => '/^\d+$/',
			'zip' => '/^[1-9]\d{5}$/',
			'integer' => '/^[-\+]?\d+$/',
			'double' => '/^[-\+]?\d+(\.\d+)?$/',
			'english' => '/^[A-Za-z]+$/',
			);
		// Ƿõʽ
		if (isset($validate[strtolower($rule)])) $rule = $validate[strtolower($rule)];
		return preg_match($rule, $value) === 1;
	}
	/**
	 * ȡֵֶ,Ψһֶ
	 *
	 * @access public
	 * @param string $field
	 * @param string $tableName
	 * @return intval
	 */
	public function getId($field = 'id', $tableName = '') {
		if ($tableName) $this -> table($tableName);
		$data = $this -> field($field) -> order($field) -> select();
		$cnt = count($data);
		if (!$cnt) return 1;
		for($i = 0; $i < $cnt; $i++) {
			$tmp = $i + 1;
			if ($tmp < $data[$i][$field]) return $tmp;
		}
		return $cnt + 1;
	}
	/**
	 * ҳ
	 *
	 * @access public
	 * @param string $url ĵַ(һھ̬ҳ)
	 * @param string $firstUrl ҳַ(һھ̬ҳ
	 * @param string $max ͬһҳ
	 * @return str
	 */
	public function pages($url = '', $firstUrl = '', $max = 10) {
		return Func :: pages($this -> page, $this -> totle, $url, $firstUrl, $this -> pageSize, $max);
	}
	/**
	 * б
	 *
	 * @access public
	 * @param mix $page ǰҳ,ֵΪ'',ʾʹ÷ҳ
	 * @param intval $pageSize ҳС
	 * @param mix $where 
	 * @param mix $order ,ַ
	 * @return array
	 */
	public function getList($page = '', $pageSize = 0, $where = array(), $order = '') {
		if (!empty($where)) $this -> where($where);
		$pageSize = intval($pageSize);
		if ($pageSize) $this -> limit($pageSize);
		if ($order == '') $order = $this -> getPk() . ' DESC';
		elseif ($order == 'none') $order = '';
		if ($order) $this -> order($order);
		if (is_numeric($page)) {
			$page = max($page, 1);
			$this -> page = $page;
			$this -> page($page);
		}
		return $this -> select();
	}
	/**
	 * ֵֶ
	 *
	 * @access public
	 * @param array $data
	 * @param mix $field
	 * @param mix $selids
	 * @return boolean
	 */
	public function setFields($data, $field = '', $selids = 0) {
		$selids or $selids = R('selids');
		if (!(empty($selids) || empty($data))) {
			$field or $field = $this -> getPk();
			$where = strstr($selids, ',')?"$field IN ($selids)":"$field=$selids";
			if (is_array($data) && $this -> create($data) -> where($where) -> update()) $r = true;
			else {
				$this -> error = L('OPERATE_FAIL');
				$r = false;
			}
		} else {
			$this -> error = L('NOPARAM');
			$r = false;
		}
		return $r;
	}
	public function param($index, $param = '', $default = '') {
		if (isset($param[$index])) {
			$r = is_numeric($param[$index])?$param[$index] + 0:$param[$index];
		} else $r = $default;
		return $r;
	}
}