<?php
// ѸCMSܻ
class Cache {
	/**
	 * ȡ
	 *
	 * @access public
	 * @param  $name 
	 * @param  $dir Ŀ¼
	 * @param  $time Чʱ 0ʾ
	 * @param  $defaultDir ĬĿ¼
	 * @return mix
	 */
	public function read($name, $dir = '', $time = 0, $defaultDir = 'Cache') {
		$cacheFile = self :: getPath($name, $dir, $defaultDir);
		if (is_file($cacheFile)) {
			$readcache = $time > 0 && TIME - filemtime($cacheFile) > $time ? false : true;
		} else $readcache = false;
		if ($readcache && is_file($cacheFile)) {
			$data = file_get_contents($cacheFile);
			if ($data) {
				$data = substr($data, strpos($data, '?>') + 2);
				$data = unserialize($data);
			}
		} else $data = false;
		return $data;
	}
	/**
	 * д뻺
	 *
	 * @access public
	 * @param  $name 
	 * @param  $data 
	 * @param  $dir Ŀ¼
	 * @param  $defaultDir ĬĿ¼
	 * @return intval ļֽ
	 */
	public function write($name, $data, $dir = '', $defaultDir = 'Cache') {
		$cacheFile = self :: getPath($name, $dir, $defaultDir);
		FileUtil :: create(dirname($cacheFile));
		$data = empty($data)?'':serialize($data);
		$strlen = file_put_contents($cacheFile, '<?php defined(\'IN_JXCMS\') or exit(\'Access Denied\');?>' . $data);
		@chmod($cacheFile, 0777);
		return $strlen;
	}
	/**
	 * ɾ
	 *
	 * @access public
	 * @param  $name 
	 * @param  $dir Ŀ¼
	 * @param  $defaultDir ĬĿ¼
	 * @return boolean
	 */
	public function del($name, $dir = '', $defaultDir = 'Cache') {
		$cacheFile = self :: getPath($name, $dir, $defaultDir);
		return @unlink($cacheFile);
	}
	/**
	 * 
	 *
	 * @access public
	 * @param  $data 
	 * @param  $name 
	 * @return intval ļֽ
	 */
	public function config($data, $name = '') {
		$name = $name?$name . '_conf':'conf';
		$cacheFile = self :: getPath($name, '', 'Config');
		$data = "<?php\n\r" . 'return ' . var_export($data, true) . ";\n";
		$strlen = file_put_contents($cacheFile, $data);
		@chmod($cacheFile, 0777);
		return $strlen;
	}
	/**
	 * ȡ·
	 *
	 * @access public
	 * @param  $name 
	 * @param  $dir Ŀ¼
	 * @param  $defaultDir ĬĿ¼
	 * @return string
	 */
	public function getPath($name, $dir = '', $defaultDir = 'Cache') {
		if ($dir) $dir = ucwords($dir) . '/';
		if ($defaultDir) $defaultDir = ucwords($defaultDir) . '/';
		$dir = JXCMS_ROOT . 'jxcms/Runtime/' . $defaultDir . $dir;
		is_dir($dir) or FileUtil :: create($dir);
		return $dir . $name . '.php';
	}
}
