<?php
/**
 * Զ
 *
 * @param string $className 
 */
function __autoload($className) {
	if (in_array($className, array('Action', 'Model', 'View', 'Db'))) {
		import('Lib/Core/' . $className, 'jxcms');
	} else {
		if (substr($className, -6) == 'Action') {
			if ($className != 'CommonAction') {
				$f = get_action_path($className);
			} else $f = JXCMS_ROOT . 'Lib/Action/CommonAction.class.php';
			file_exists($f) or $msg = L('ACTION_NOT_EXIST');
		} elseif (substr($className, -5) == 'Model') {
			$f = get_model_path($className);
			file_exists($f) or $msg = L('MODEL_NOT_EXIST');
		} else {
			$file = 'Lib/Public/' . $className . '.class.php';
			$f = JXCMS_ROOT . MODULE_DIR . $file;
			file_exists($f) or $f = JXCMS_ROOT . $file;
			file_exists($f) or $f = JXCMS_ROOT . 'jxcms/' . $file;
			file_exists($f) or $msg = L('CLASS_NOT_EXIST');
		}
		empty($msg) or show_error($className . $msg);
		include $f;
	}
}
/**
 * ļ
 *
 * @param string $path ģĿ¼·Ϣ
 * @param string $moduleDir ģĿ¼,ڿģ
 * @param string $ext չ
 */
function import($path, $moduleDir = '', $ext = '.class.php') {
	if ($moduleDir && substr($moduleDir, -1) != '/') $moduleDir .= '/';
	$f = JXCMS_ROOT . $moduleDir . $path . $ext;
	if (!file_exists($f)) return false;
	if ($ext == '.class.php') {
		if (!class_exists(basename($f, '.class.php'), false)) include $f;
	} else include_once $f;
	return true;
}
function get_action_path($actionFullName, $moduleDir = '') {
	$appGroup = defined('APP_GROUP') && APP_GROUP ? APP_GROUP . '/' : '';
	$moduleDir = $moduleDir ? $moduleDir . '/' : MODULE_DIR;
	$f = JXCMS_ROOT . $moduleDir . 'Lib/Action/' . $appGroup . $actionFullName . '.class.php'; //˷,ڷĿ¼
	return $f;
}
/**
 * ȡģ·
 *
 * @param string $modelFullName ģ
 * @param string $moduleDir ģĿ¼,ڿģʱҪָ
 */
function get_model_path($modelFullName, $moduleDir = '') {
	$moduleDir = $moduleDir ? $moduleDir . '/' : MODULE_DIR;
	$dir = JXCMS_ROOT . $moduleDir . 'Lib/Model/';
	$file = $modelFullName . '.class.php';
	if (defined('APP_GROUP') && APP_GROUP) {
		$f = $dir . APP_GROUP . '/' . $file;
		if (!file_exists($f)) $f = $dir . $file;
		if (!file_exists($f) && $moduleDir) {
			$dir = JXCMS_ROOT . 'Lib/Model/';
			$f = $dir . APP_GROUP . '/' . $file;
			if (!file_exists($f)) $f = $dir . $file;
		}
	} else {
		$f = $dir . $file;
		if (!file_exists($f) && $moduleDir) $f = JXCMS_ROOT . 'Lib/Model/' . $file;
	}
	return $f;
}
/**
 * ֶģ
 *
 * @param string $className 
 * @param string $moduleDir ģĿ¼,ڿģʱҪָ
 * @param mix $init ʼ,Ϊ鼴
 */
function M($className, $moduleDir = '', $init = '') {
	if (!class_exists('Model', false)) import('Lib/Core/Model', 'jxcms');
	if ($className != 'Model') {
		$className = ucwords($className) . 'Model';
		if (!class_exists($className, false)) {
			$f = get_model_path($className, $moduleDir);
			if (file_exists($f)) include $f;
			else {
				return new Model($className);
			}
		}
	}
	return new $className($init);
}
/**
 * ȡϵͳ
 *
 * @param string $index ֶ
 * @param string $isSys Ƿϵͳ
 * @param string $moduleNameOrDir ģƻĿ¼,$isSysΪ1Ŀ¼Ϊ0ʱ
 * return mix
 */
function C($index = '', $isSys = 0, $moduleNameOrDir = '') {
	static $_config = array();
	if ($moduleNameOrDir) {
		if ($moduleNameOrDir == 'root') $moduleNameOrDir = '';
		else $moduleNameOrDir .= '/';
	} else {
		$moduleNameOrDir = MODULE_DIR;
	}
	if ($isSys) {
		$c = 'sys_config';
		$dir = JXCMS_ROOT;
		$file = 'config.php';
	} else {
		$c = 'normal_config';
		$dir = JXCMS_ROOT . 'jxcms/Runtime/Config/';
		$file = 'conf.php';
	}
	if (!isset($_config[$c])) {
		if (file_exists($f = $dir . $file)) $tmp = include($f);
		else $tmp = array();
		$_config[$c] = $tmp;
	}
	$config = $_config[$c];
	if ($moduleNameOrDir) {
		$c = substr($moduleNameOrDir, 0, -1) . '_' . $c;
		if (!isset($_config[$c])) {
			if ($isSys) $tmp = $moduleNameOrDir;
			else $tmp = substr($moduleNameOrDir, 0, -1) . '_';
			if (file_exists($f = $dir . $tmp . $file)) $tmp = include($f);
			else $tmp = array();
			if ($isSys && !isset($tmp['APP_DIR'])) $tmp['APP_DIR'] = $config['APP_DIR'] . $moduleNameOrDir;
			$_config[$c] = $tmp;
		}
		empty($_config[$c]) or $config = array_merge($config, $_config[$c]); //ģøȫ
	}
	if (empty($index)) return $config;
	return isset($config[$index]) ? $config[$index] : '';
}
/**
 * ȡϵͳ
 *
 * @param string $index 
 * @param string $name ԰ļ
 * @param string $moduleDir ģĿ¼,ڿģ
 */
function L($index = '', $name = '', $moduleDir = '') {
	static $_lang = array();
	$name = $name?strtolower($name):'common';
	if ($moduleDir) $moduleDir .= '/';
	else $moduleDir = MODULE_DIR;
	// ԰
	if (!isset($_lang['frame'])) {
		if (file_exists($f = JXCMS_ROOT . 'jxcms/Lib/Lang/' . C('APP_LANG', 1) . '.php')) $tmp = include($f);
		else $tmp = array();
		$_lang['frame'] = $tmp;
	}
	$lang = $_lang['frame'];
	// ϵͳ԰Ŀ¼
	$dir = JXCMS_ROOT . 'Lib/Lang/' . C('APP_LANG', 1) . '/';
	// ϵͳ԰
	$c = 'sys_common';
	if (!isset($_lang[$c])) {
		if (file_exists($f = $dir . 'common.php')) {
			$tmp = include($f);
		} else $tmp = array();
		$_lang[$c] = $tmp;
	}
	empty($_lang[$c]) or $lang = array_merge($lang, $_lang[$c]); //ϵͳ԰  ԰
	// δָ԰ļָΪļʱ,Զط԰
	if ($name == 'common' && defined('APP_GROUP') && APP_GROUP) $name = strtolower(APP_GROUP);
	// ϵͳ԰
	if ($name != 'common') {
		$c = 'sys_' . $name;
		if (!isset($_lang[$c])) {
			if (file_exists($f = $dir . $name . '.php')) $tmp = include($f);
			else $tmp = array();
			$_lang[$c] = $tmp;
		}
		empty($_lang[$c]) or $lang = array_merge($lang, $_lang[$c]); //ϵͳָ԰  ԰
	}
	if ($moduleDir) {
		$moduleName = substr($moduleDir, 0, -1);
		// ģ԰Ŀ¼
		$dir = JXCMS_ROOT . $moduleDir . 'Lib/Lang/' . C('APP_LANG', 1) . '/';
		// ģ鹫԰
		$c = $moduleName . '_common';
		if (!isset($_lang[$c])) {
			if (file_exists($f = $dir . 'common.php')) $tmp = include($f);
			else $tmp = array();
			$_lang[$c] = $tmp;
		}
		empty($_lang[$c]) or $lang = array_merge($lang, $_lang[$c]); //ģ鹫԰  ԰
		if ($name != 'common') {
			$c = $moduleName . '_' . $name;
			if (!isset($_lang[$c])) {
				if (file_exists($f = $dir . $name . '.php')) $tmp = include($f);
				else $tmp = array();
				$_lang[$c] = $tmp;
			}
			empty($_lang[$c]) or $lang = array_merge($lang, $_lang[$c]); //ģָ԰  ԰
		}
	}
	if (empty($index)) return $lang;
	$index = strtoupper($index);
	return isset($lang[$index])?$lang[$index]:str_replace('_', ' ', $index);
}
/**
 * ȡ
 *
 * @param string $name 
 * @param string $type get or post
 * @return string
 */
function R($name, $type = '') {
	$str = '';
	if (empty($type)) {
		if (isset($_POST[$name])) $str = $_POST[$name];
		elseif (isset($_GET[$name])) $str = $_GET[$name];
	} else {
		$type = strtolower($type);
		if ($type == 'post') {
			if (isset($_POST[$name])) $str = $_POST[$name];
		} elseif (isset($_GET[$name])) $str = $_GET[$name];
	}
	return $str;
}
// ȡڴʹڼڴʹ
function get_run_memory() {
	$m = memory_get_usage() - SYS_START_MEMORY;
	if ($m < 1024) $m = $m . 'b';
	elseif ($m < 1048576) $m = round($m / 1024, 2) . 'kb';
	else $m = round($m / 1048576, 2) . 'mb';
	return $m;
}

/**
 * ִʱ
 *
 * @param float $start
 * @return int λs
 */
function get_run_time($start = 0) {
	$stime = $start?$start:SYS_START_TIME;
	$etime = microtime(true);
	return number_format(($etime - $stime), 6) . 's';
}
// ʾʾ
function show_error($error) {
	$error = htmlspecialchars($error);
	if (C('APP_DEBUG', 1)) {
		Cache :: write('debug', debug_backtrace());
		if (defined('IN_ADMIN'))$error .= '<br /><a href="?a=debug" target="_blank">Show Debug info!</a>';
	}
	$power = Tag :: power();
	include JXCMS_ROOT . 'jxcms/Tpl/error.php';
	exit;
}
/**
 * QUERY_STRINGֵָ
 *
 * @param string $key Ҫɾֵ,|ָ
 * @return str
 */
function del_query_string($key = '') {
	$str = $_SERVER['QUERY_STRING'];
	$tmp = explode('&', $str);
	$key = explode('|', strtolower($key));
	if (!empty($key)) {
		$array = array();
		foreach($tmp as $field) {
			$t = explode('=', $field);
			if (!in_array(strtolower($t[0]), $key))$array[] = $field;
		}
		$str = implode('&', $array);
	}
	return $str;
}
/**
 * COOKIE
 *
 * @param string $index 
 * @param mix $value ֵ
 * @param int $life 
 * @return boolean
 */
function set_cookie($index, $value, $life = 0) {
	if (empty($index)) return false;
	if (is_string($value)) $value = iconv(C('APP_CHARSET', 1), 'utf-8', $value);
	elseif (is_array($value)) {
		$value = 'array_' . base64_encode(serialize($value));
	}
	return setcookie('mb_159f32d4e0a8c7_' . $index, $value, $life?TIME + $life:0, C('COOKIE_PATH', 1), C('COOKIE_DOMAIN', 1), $_SERVER['SERVER_PORT'] == 443?1:0);
}
/**
 * ȡCOOKIE
 *
 * @param string $index 
 * @return mix
 */
function get_cookie($index) {
	if (empty($index)) return '';
	$index = 'mb_159f32d4e0a8c7_' . $index;
	if (!isset($_COOKIE[$index])) return '';
	if (substr($_COOKIE[$index], 0, 6) == 'array_') $value = unserialize(base64_decode(substr($_COOKIE[$index], 6)));
	else $value = iconv('utf-8', C('APP_CHARSET', 1), $_COOKIE[$index]);
	return $value;
}
/**
 * ַת
 *
 * @access protected
 * @param string $name ַ
 * @param integer $type ת 0 JavaתΪCķ,1 CתΪJavaķ
 * @return string
 */
function parse_name($name, $type = 0) {
	if ($type) {
		$name = str_replace('_', ' ', $name);
		return str_replace(' ', '', ucwords($name));
	} else {
		$name = preg_replace("/[A-Z]/", "_\\0", $name);
		return strtolower(trim($name, '_'));
	}
}
/**
 * ȡģ
 *
 * @param mix $name ID/NAME
 * @param string $index
 * @return mix
 */
function get_module($name = 0, $index = '') {
	static $module = array();
	$module or $module = Cache :: read('module', '', 0, 'Data');
	$rs = array();
	if ($name === 0) {
		$rs = $module;
	} else {
		if (is_numeric($name)) {
			$rs = $module[$name];
		} elseif ($name) {
			foreach($module as $tmp) {
				if ($tmp['name'] == $name) {
					$rs = $tmp;
					break;
				}
			}
		}
		if (empty($rs)) show_error(L('MODEL_CALL_UNDEFINE'));
		if ($index) $rs = isset($rs[$index])?$rs[$index]:'';
	}
	return $rs;
}
/**
 * ȡĿ
 *
 * @param int $catid
 * @param string $index
 * @return mix
 */
function get_category($catid = '', $index = '') {
	static $category = array();
	$category or $category = Cache :: read('category');
	if ($catid === '') $rs = $category;
	else {
		$catid = intval($catid);
		$rs = isset($category[$catid])?$category[$catid]:'';
		if ($index) $rs = isset($rs[$index])?$rs[$index]:'';
	}
	return $rs;
}