jQuery.extend({


    createUploadIframe: function(id, uri)
	{
			//create frame
            var frameId = 'jUploadFrame' + id;
            var iframeHtml = '<iframe id="' + frameId + '" name="' + frameId + '" style="position:absolute; top:-9999px; left:-9999px"';
			if(window.ActiveXObject)
			{
                if(typeof uri== 'boolean'){
					iframeHtml += ' src="' + 'javascript:false' + '"';

                }
                else if(typeof uri== 'string'){
					iframeHtml += ' src="' + uri + '"';

                }
			}
			iframeHtml += ' />';
			jQuery(iframeHtml).appendTo(document.body);

            return jQuery('#' + frameId).get(0);
    },
    createUploadForm: function(id, fileElementId, data)
	{
		//create form
		var formId = 'jUploadForm' + id;
		var fileId = 'jUploadFile' + id;
		var form = jQuery('<form  action="" method="POST" name="' + formId + '" id="' + formId + '" enctype="multipart/form-data"></form>');
		if(data)
		{
			for(var i in data)
			{
				jQuery('<input type="hidden" name="' + i + '" value="' + data[i] + '" />').appendTo(form);
			}
		}
		var oldElement = jQuery('#' + fileElementId);
		var newElement = jQuery(oldElement).clone();
		jQuery(oldElement).attr('id', fileId);
		jQuery(oldElement).before(newElement);
		jQuery(oldElement).appendTo(form);



		//set attributes
		jQuery(form).css('position', 'absolute');
		jQuery(form).css('top', '-1200px');
		jQuery(form).css('left', '-1200px');
		jQuery(form).appendTo('body');
		return form;
    },

    ajaxFileUpload: function(s) {
        // TODO introduce global settings, allowing the client to modify them for all requests, not only timeout
        s = jQuery.extend({}, jQuery.ajaxSettings, s);
        var id = new Date().getTime()
		var form = jQuery.createUploadForm(id, s.fileElementId, (typeof(s.data)=='undefined'?false:s.data));
		var io = jQuery.createUploadIframe(id, s.secureuri);
		var frameId = 'jUploadFrame' + id;
		var formId = 'jUploadForm' + id;
        // Watch for a new set of requests
        if ( s.global && ! jQuery.active++ )
		{
			jQuery.event.trigger( "ajaxStart" );
		}
        var requestDone = false;
        // Create the request object
        var xml = {}
        if ( s.global )
            jQuery.event.trigger("ajaxSend", [xml, s]);
        // Wait for a response to come back
        var uploadCallback = function(isTimeout)
		{
			var io = document.getElementById(frameId);
            try
			{
				if(io.contentWindow)
				{
					 xml.responseText = io.contentWindow.document.body?io.contentWindow.document.body.innerHTML:null;
                	 xml.responseXML = io.contentWindow.document.XMLDocument?io.contentWindow.document.XMLDocument:io.contentWindow.document;

				}else if(io.contentDocument)
				{
					 xml.responseText = io.contentDocument.document.body?io.contentDocument.document.body.innerHTML:null;
                	xml.responseXML = io.contentDocument.document.XMLDocument?io.contentDocument.document.XMLDocument:io.contentDocument.document;
				}
            }catch(e)
			{
				jQuery.handleError(s, xml, null, e);
			}
            if ( xml || isTimeout == "timeout")
			{
                requestDone = true;
                var status;
                try {
                    status = isTimeout != "timeout" ? "success" : "error";
                    // Make sure that the request was successful or notmodified
                    if ( status != "error" )
					{
                        // process the data (runs the xml through httpData regardless of callback)
                        var data = jQuery.uploadHttpData( xml, s.dataType );
                        // If a local callback was specified, fire it and pass it the data
                        if ( s.success )
                            s.success( data, status );

                        // Fire the global callback
                        if( s.global )
                            jQuery.event.trigger( "ajaxSuccess", [xml, s] );
                    } else
                        jQuery.handleError(s, xml, status);
                } catch(e)
				{
                    status = "error";
                    jQuery.handleError(s, xml, status, e);
                }

                // The request was completed
                if( s.global )
                    jQuery.event.trigger( "ajaxComplete", [xml, s] );

                // Handle the global AJAX counter
                if ( s.global && ! --jQuery.active )
                    jQuery.event.trigger( "ajaxStop" );

                // Process result
                if ( s.complete )
                    s.complete(xml, status);

                jQuery(io).unbind()

                setTimeout(function()
									{	try
										{
											jQuery(io).remove();
											jQuery(form).remove();

										} catch(e)
										{
											jQuery.handleError(s, xml, null, e);
										}

									}, 100)

                xml = null

            }
        }
        // Timeout checker
        if ( s.timeout > 0 )
		{
            setTimeout(function(){
                // Check to see if the request is still happening
                if( !requestDone ) uploadCallback( "timeout" );
            }, s.timeout);
        }
        try
		{

			var form = jQuery('#' + formId);
			jQuery(form).attr('action', s.url);
			jQuery(form).attr('method', 'POST');
			jQuery(form).attr('target', frameId);
            if(form.encoding)
			{
				jQuery(form).attr('encoding', 'multipart/form-data');
            }
            else
			{
				jQuery(form).attr('enctype', 'multipart/form-data');
            }
            jQuery(form).submit();

        } catch(e)
		{
            jQuery.handleError(s, xml, null, e);
        }

		jQuery('#' + frameId).load(uploadCallback	);
        return {abort: function () {}};

    },

    uploadHttpData: function( r, type ) {
        var data = !type;
        data = type == "xml" || data ? r.responseXML : r.responseText;
        // If the type is "script", eval it in global context
        if ( type == "script" )
            jQuery.globalEval( data );
        // Get the JavaScript object, if JSON is used.
        if ( type == "json" )
            eval( "data = " + data );
        // evaluate scripts within html
        if ( type == "html" )
            jQuery("<div>").html(data).evalScripts();

        return data;
    }
});


/*
 * jxupload 1.0
 * Copyright (c) 2013 Dacheng  http://www.jxcms.com/
 * Date: 2013-03-14
 */
 (function($){
    $.fn.jxupload = function(module, type, txt){
        if(typeof(module) == "undefined") return false;
		if(typeof(txt) == "undefined") txt = '上传';
		var self = this;
		var id = $(this).attr('id');
		var html = '<span id="jxupload_span_'+id+'" style="vertical-align:middle;display:inline-block;position:relative;overflow:hidden;margin-left:2px;"><button id="jxupload_btn_'+id+'">'+txt+'</button><input type="file" name="fileToUpload" id="jxupload_file_'+id+'" style="position:absolute;cursor:pointer;top:0;right:0;filter:alpha(opacity=0);-khtml-opacity:0;-moz-opacity:0;opacity:0;z-index:2;"></span>';
		$(this).after(html);
		$('#jxupload_file_'+id).height($(this).height()+4);
		$('#jxupload_file_'+id).change(function(){
			var tmp = $(this).val();
			var upload_type = {};
			$.ajaxSettings.async = false;
			$.getJSON('index.php?c=common&a=get_upload_type', function(json){
				upload_type = json;
			});
			$.ajaxSettings.async = true;
			switch(type){
				case 'image':
					if(!self.IsExt(tmp,upload_type.image)){
						alert('图片格式只能为'+upload_type.image);
						return false;
					}
					break;
				case 'flash':
					if(!self.IsExt(tmp,upload_type.flash)){
						alert('flash格式只能为'+upload_type.flash);
						return false;
					}
					break;
				case 'file':
					if(!self.IsExt(tmp,upload_type.file)){
						alert('文件格式只能为'+upload_type.file);
						return false;
					}
					break;
				case 'media':
					if(!self.IsExt(tmp,upload_type.media)){
						alert('媒体格式只能为'+upload_type.media);
						return false;
					}
					break;
				case 'attach':
					if(!(self.IsExt(tmp,upload_type.image) || self.IsExt(tmp,upload_type.flash) || self.IsExt(tmp,upload_type.file) || self.IsExt(tmp,upload_type.media))){
						alert('您选择的文件类型不允许上传！');
						return false;
					}
					break;
			}
			$.ajaxFileUpload({
				url:'index.php?c=common&a=upload&module='+module+'&type='+type,
				secureuri:false,
				fileElementId:'jxupload_file_'+id,
				dataType:'json',
				success:function(data, status){
					if(data.err != '') {
						alert(data.err);
					} else {
						$(self).val(data.msg);
						$(self).blur();
					}
				},
				error:function(data, status, e){alert(e);}
			});
		});
		this.IsExt = function(url, opt){
			var sTemp;
			var b=false;
			var s=opt.toUpperCase().split("|");
			for(var i=0;i<s.length ;i++ ){
				sTemp=url.substr(url.length-s[i].length-1);
				sTemp=sTemp.toUpperCase();
				s[i]="."+s[i];
				if(s[i]==sTemp){
					b=true;
					break;
				}
			}
			return b;
		}
	}
})(jQuery);
