var __gG = function(window, undefined) {
  var $ = window.Grapery1;
  clearInterval($.i);
  $.config = {collectors:["col3.707wa.com"], cacheGetUrl:"http://stat.707wa.com/code.js", cacheSetUrl:"http://stat.707wa.com/code.php", flashPath:"http://stat.707wa.com/fc.swf", tpcUrl:"http://stat.707wa.com/tpc.php", host:"707wa.com", notifierFilesPath:"http://stat2.707wa.com/notifier_files/"};
  $.currentCollector = Math.floor(Math.random() * $.config.collectors.length);
  $.host = $.config.host;
  $.name = "Grapery1";
  $.helpers = {trim:function(str) {
    return str.replace(/^\s+/, "").replace(/\s+$/, "")
  }, trimLeft:function(str) {
    return str.replace(/^\s+/, "")
  }, trimRight:function(str) {
    return str.replace(/\s+$/, "")
  }, getAttributeValue:function(element, attrName) {
    if(element.attributes.getNamedItem) {
      return element.attributes.getNamedItem(attrName) ? element.attributes.getNamedItem(attrName).value : null
    }
    if(element.attributes[attrName]) {
      return element.attributes[attrName].value
    }
    return null
  }, truncateTitle:function(title, maxLength, separator) {
    maxLength = maxLength || 127;
    separator = separator || " ... ";
    title = this.trim(title.replace(/\s{2,}/g, " "));
    if(title.length <= maxLength) {
      return title
    }
    var difference = title.length - maxLength + separator.length;
    var breakStartIndex = Math.floor(title.length / 2 - difference / 2);
    var breakEndIndex = breakStartIndex + difference + 1;
    var words = title.split(/\s+/);
    if(words.length == 1) {
      return title.substring(0, breakStartIndex) + separator + title.substr(breakEndIndex)
    }
    var leftWords = [];
    var rightWords = [];
    var newLength = 0;
    var middleIndex = Math.ceil(words.length / 2);
    for(var i = 0;i < middleIndex;i++) {
      leftWords.push(words[i]);
      newLength += words[i].length + 1;
      if(newLength + separator.length >= maxLength || newLength + words[words.length - 1 - i].length + separator.length > maxLength) {
        break
      }
      rightWords.unshift(words[words.length - 1 - i]);
      newLength += words[words.length - 1 - i].length + 1;
      if(newLength + separator.length >= maxLength || i + 1 < middleIndex && newLength + words[i + 1].length + separator.length > maxLength) {
        break
      }
    }
    if(leftWords.length == 1 && rightWords.length == 0 && leftWords[0].length + separator.length > maxLength) {
      leftWords[0] = leftWords[0].substr(0, maxLength - separator.length)
    }
    var trimmedSeparator = this.trim(separator);
    if(leftWords.length && leftWords[leftWords.length - 1] == trimmedSeparator) {
      leftWords.pop()
    }
    if(rightWords.length && rightWords[0] == trimmedSeparator) {
      rightWords.shift()
    }
    return leftWords.join(" ") + separator + rightWords.join(" ")
  }, bindEvent:function(element, evtType, func) {
    try {
      if(element.addEventListener) {
        element.addEventListener(evtType, func, false);
        return
      }
      if(element.attachEvent) {
        element.attachEvent("on" + evtType, func);
        return
      }
      element.customEventHandlers = element.customEventHandlers || {};
      if(!element.customEventHandlers[evtType]) {
        element.customEventHandlers[evtType] = {defaultHandler:element["on" + evtType], lastHandler:null, handlers:[func]}
      }else {
        if(element["on" + evtType] !== element.customEventHandlers[evtType].lastHandler) {
          element.customEventHandlers[evtType].defaultHandler = element["on" + evtType];
          element.customEventHandlers[evtType].lastHandler = null
        }
        element.customEventHandlers[evtType].handlers.push(func)
      }
      if(element.customEventHandlers[evtType].lastHandler !== null) {
        return
      }
      element.customEventHandlers[evtType].lastHandler = element["on" + evtType] = function(eventHandler) {
        return function(event) {
          var lastResult;
          for(var i = 0;i < eventHandler.handlers.length;i++) {
            lastResult = eventHandler.handlers[i].call(this, event)
          }
          if(eventHandler.defaultHandler) {
            return eventHandler.defaultHandler.call(this, event)
          }
          return lastResult
        }
      }(element.customEventHandlers[evtType])
    }catch(e) {
      $.handleAgentException(e.message, e.lineNumber)
    }
  }, unbindEvent:function(element, evtType, func) {
    try {
      if(element.removeEventListener) {
        element.removeEventListener(evtType, func, false);
        return
      }
      if(element.detachEvent) {
        element.detachEvent("on" + evtType, func);
        return
      }
      if(element.customEventHandlers && element.customEventHandlers[evtType]) {
        for(var i = 1;i < element.customEventHandlers[evtType].length;i++) {
          if(element.customEventHandlers[evtType][i] === func) {
            element.customEventHandlers[evtType].splice(i, 1);
            break
          }
        }
      }
    }catch(e) {
      $.handleAgentException(e.message, e.lineNumber)
    }
  }, normalizeEvent:function(event) {
    event = event || window.event;
    if(!event.target) {
      event.target = event.srcElement
    }
    return event
  }, toUTF8:function(str) {
    str = str.replace(/\r\n/g, "\n");
    var utf8Text = "";
    for(var n = 0;n < str.length;n++) {
      var c = str.charCodeAt(n);
      if(c < 128) {
        utf8Text += String.fromCharCode(c)
      }else {
        if(c > 127 && c < 2048) {
          utf8Text += String.fromCharCode(c >> 6 | 192);
          utf8Text += String.fromCharCode(c & 63 | 128)
        }else {
          utf8Text += String.fromCharCode(c >> 12 | 224);
          utf8Text += String.fromCharCode(c >> 6 & 63 | 128);
          utf8Text += String.fromCharCode(c & 63 | 128)
        }
      }
    }
    return utf8Text
  }, crc32:function(str) {
    str = this.toUTF8(str);
    var table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
    var crc = 0 ^ -1;
    var x = 0;
    var y = 0;
    for(var i = 0, iTop = str.length;i < iTop;i++) {
      y = (crc ^ str.charCodeAt(i)) & 255;
      x = "0x" + table.substr(y * 9, 8);
      crc = crc >>> 8 ^ parseInt(x)
    }
    return crc ^ -1
  }, handleAjaxNavigation:function(handler) {
    var prevHash = location.hash.replace(/^#/, "");
    function anchorExists(hash) {
      if(document.getElementById(hash)) {
        return true
      }
      var elements = document.getElementsByName(hash);
      for(var i = 0;i < elements.length;i++) {
        if(elements[i].nodeName.toUpperCase == "A") {
          return true
        }
      }
      return false
    }
    function handle() {
      var hash = location.hash.replace(/^#/, "");
      if(hash == prevHash) {
        return
      }
      if(hash == "") {
        if(location.href.indexOf("#") != -1 || anchorExists(prevHash)) {
          return
        }
      }else {
        if(anchorExists(hash)) {
          return
        }
      }
      prevHash = hash;
      handler()
    }
    var hashListenInterval = setInterval(handle, 1E3);
    function hashChanged() {
      if(hashListenInterval) {
        clearInterval(hashListenInterval)
      }
      handle()
    }
    this.bindEvent(window, "hashchange", hashChanged)
  }, cookie:function(key, value, temporary) {
    if(typeof key === "undefined" || key === null || key === "") {
      return false
    }
    if(typeof value !== "undefined") {
      var cookieString = encodeURIComponent(key) + "=" + encodeURIComponent(value);
      var expiresDate = new Date;
      if(value === null || value === "") {
        cookieString += "; expires=Thu, 01-Jan-70 00:00:01 GMT"
      }else {
        if(typeof temporary === "undefined") {
          expiresDate.setDate(expiresDate.getDate() + 3650);
          cookieString += "; expires=" + expiresDate.toGMTString()
        }
      }
      cookieString += "; path=/";
      if(/^[a-z0-9\.\-]+$/i.test(document.domain)) {
        cookieString += "; domain=." + document.domain.replace(/^www\./, "")
      }
      document.cookie = cookieString;
      return true
    }
    var cookies = document.cookie.split(/;\s*/);
    for(var i = 0;i < cookies.length;i++) {
      var c = cookies[i].split("=");
      if(decodeURIComponent(c[0]) == key) {
        return c[1] ? decodeURIComponent(c[1]) : ""
      }
    }
    return""
  }, getFormattedDate:function(date) {
    date = date || new Date;
    return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate() + " " + date.getHours() + ":" + +date.getMinutes() + ":" + date.getSeconds()
  }, jsonp:function(src, keepInDOM, successCallback, errorCallback) {
    try {
      var script = document.createElement("script");
      script.setAttribute("type", "text/javascript");
      script.setAttribute("charset", "utf-8");
      script.setAttribute("src", src);
      script.async = true;
      var errorTimeout = null;
      var readyStateChangeTimeout = null;
      var loaded = false;
      function complete() {
        if(loaded) {
          return
        }
        loaded = true;
        clearTimeout(errorTimeout);
        if(readyStateChangeTimeout) {
          clearTimeout(readyStateChangeTimeout)
        }
        script.onload = script.onreadystatechange = script.onerror = null;
        if(!keepInDOM) {
          script.parentNode.removeChild(script);
          script = null
        }
      }
      script.onload = function() {
        complete();
        if(successCallback) {
          successCallback()
        }
      };
      script.onreadystatechange = function() {
        if(script.readyState === "loaded" || script.readyState === "complete") {
          if(readyStateChangeTimeout) {
            clearTimeout(readyStateChangeTimeout)
          }
          readyStateChangeTimeout = setTimeout(script.onload, 20)
        }
      };
      script.onerror = function() {
        complete();
        if(errorCallback) {
          errorCallback()
        }
      };
      errorTimeout = setTimeout(script.onerror, 1E4);
      document.getElementsByTagName("head")[0].appendChild(script)
    }catch(e) {
      $.handleAgentException(e.message, e.lineNumber)
    }
  }};
  var cookie = $.helpers.cookie;
  cookie("grapery_f1", $.c);
  $.e = function(requestIndex) {
    msg.completeRequest(requestIndex)
  };
  $.auth = function(pCode, requestIndex) {
    msg.completeRequest(requestIndex);
    if(requestIndex == msg.initRequestIndex) {
      $.pCode = pCode;
      agent.authorized = true
    }
    if(!$.cCode) {
      storage.setCode(pCode)
    }
    msg.sendDelayedRequests(requestIndex, pCode)
  };
  $.valid = function(code, index, requestIndex) {
    msg.completeRequest(requestIndex);
    if(index == storage.lastIndex) {
      storage.setCode(code)
    }
  };
  var msg = {delayedRequests:{}, delayedRequestsCount:0, activeRequests:{}, activeRequestsCount:0, mutexIndex:0, requestIndex:0, initRequestIndex:0, iteration:0, alive:true, lastSuccessfulRequestDate:function() {
    return new Date
  }(), generateCache:function(length) {
    return Math.floor(Math.random() * Math.pow(10, length)).toString()
  }, getRequestIndex:function() {
    var index = msg.requestIndex;
    msg.requestIndex++;
    return index
  }, changeCollector:function(requestIndex) {
    if(msg.mutexIndex == 0 || msg.mutexIndex == requestIndex) {
      msg.mutexIndex = requestIndex;
      $.currentCollector = ($.currentCollector + 1) % $.config.collectors.length
    }
  }, completeRequest:function(requestIndex) {
    try {
      msg.lastSuccessfulRequestDate = new Date;
      var requestObj = msg.activeRequests["r_" + requestIndex];
      if(!requestObj) {
        return
      }
      if(requestObj.callback) {
        requestObj.callback()
      }
      if(requestObj.script) {
        requestObj.script.onload = requestObj.script.onreadystatechange = requestObj.script.onerror = null;
        requestObj.script.parentNode.removeChild(requestObj.script);
        requestObj.script = null
      }
      if(requestObj.index == msg.mutexIndex) {
        msg.mutexIndex = 0
      }
      requestObj = null;
      delete msg.activeRequests["r_" + requestIndex];
      msg.activeRequestsCount--
    }catch(e) {
      $.handleAgentException(e.message, e.lineNumber)
    }
  }, request:function(requestObj) {
    function requestFailed() {
      try {
        requestObj.script.onload = requestObj.script.onreadystatechange = requestObj.script.onerror = null;
        requestObj.script.parentNode.removeChild(requestObj.script);
        requestObj.script = null;
        if(msg.alive && new Date - msg.lastSuccessfulRequestDate > 3E5) {
          msg.alive = false
        }
        if(!msg.alive || requestObj.limit && requestObj.step + 1 >= requestObj.limit) {
          if(requestObj.index == msg.mutexIndex) {
            msg.mutexIndex = 0
          }
          delete msg.activeRequests["r_" + requestObj.index];
          msg.activeRequestsCount--;
          requestObj = null;
          return
        }
        msg.changeCollector(requestObj.index);
        requestObj.step++;
        setTimeout(function() {
          msg.request(requestObj)
        }, 1500)
      }catch(e) {
        $.handleAgentException(e.message, e.lineNumber)
      }
    }
    try {
      requestObj.script = document.createElement("script");
      requestObj.script.setAttribute("type", "text/javascript");
      requestObj.script.setAttribute("charset", "utf-8");
      requestObj.script.async = true;
      if(typeof requestObj.data !== "string") {
        requestObj.data = msg.format(requestObj.data);
        requestObj.sign = $.helpers.crc32(requestObj.data)
      }
      if(requestObj.data.charAt(0) == "?") {
        requestObj.script.setAttribute("src", "http://" + $.config.collectors[$.currentCollector] + "/" + requestObj.data + "&t=" + requestObj.index)
      }else {
        requestObj.script.setAttribute("src", "http://" + $.config.collectors[$.currentCollector] + "/?" + requestObj.data + "&i=" + requestObj.step + "&n=" + msg.generateCache(5) + "&t=" + requestObj.index + "&k=" + requestObj.sign)
      }
      requestObj.script.onload = function() {
        if(!msg.activeRequests["r_" + requestObj.index]) {
          requestObj = null;
          return
        }
        requestFailed()
      };
      requestObj.script.onreadystatechange = function() {
        if(requestObj.script.readyState === "loaded" || requestObj.script.readyState === "complete") {
          setTimeout(requestObj.script.onload, 10)
        }
      };
      requestObj.script.onerror = requestFailed;
      requestObj.date = new Date;
      document.getElementsByTagName("head")[0].appendChild(requestObj.script)
    }catch(e) {
      $.handleAgentException(e.message, e.lineNumber)
    }
  }, send:function(data, callback, immediately, limit) {
    try {
      if(!msg.alive) {
        return
      }
      var index = msg.getRequestIndex();
      var requestObj = {data:data, step:0, index:index, sign:0, callback:callback, script:null, limit:typeof limit !== "undefined" ? limit : $.config.collectors.length};
      if(agent.authorized || immediately) {
        if(msg.activeRequests >= 100) {
          $.handleAgentException("\u0427\u0438\u0441\u043b\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u043e 100");
          return
        }
        msg.activeRequests["r_" + index] = requestObj;
        msg.activeRequestsCount++;
        msg.request(msg.activeRequests["r_" + index]);
        return
      }
      if(msg.delayedRequestsCount >= 100) {
        $.handleAgentException("\u041e\u0431\u0449\u0435\u0435 \u0447\u0438\u0441\u043b\u043e \u043e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u043e 100");
        return
      }
      msg.delayedRequests["r_" + msg.initRequestIndex].push(requestObj);
      msg.delayedRequestsCount++
    }catch(e) {
      $.handleAgentException(e.message, e.lineNumber)
    }
  }, sendDelayedRequests:function(initRequestIndex, pCode) {
    try {
      if(typeof msg.delayedRequests["r_" + initRequestIndex] === "undefined") {
        return
      }
      var requestObj = null;
      while(msg.delayedRequests["r_" + initRequestIndex].length) {
        requestObj = msg.delayedRequests["r_" + initRequestIndex].pop();
        msg.delayedRequestsCount--;
        requestObj.data.pCode = pCode;
        msg.activeRequests["r_" + requestObj.index] = requestObj;
        msg.activeRequestsCount++;
        msg.request(msg.activeRequests["r_" + requestObj.index])
      }
      delete msg.delayedRequests["r_" + initRequestIndex]
    }catch(e) {
      $.handleAgentException("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0445 \u0441\u043e\u0431\u044b\u0442\u0438\u0439: " + e.message, e.lineNumber)
    }
  }, format:function(params) {
    params.siteID = params.siteID || $.sCode;
    params.pCode = params.pCode || $.pCode || "";
    params.cCode = params.cCode || $.cCode || "";
    params.cDate = encodeURIComponent($.helpers.getFormattedDate());
    params.iter = msg.iteration++;
    if(params.event != 1 && params.pCode == "") {
      $.handleAgentException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b")
    }
    var result = "";
    for(var key in params) {
      result += key + "=";
      if(params[key] !== null) {
        result += params[key]
      }
      result += "&"
    }
    return result.substring(0, result.length - 1)
  }};
  (function() {
    var currentOnError = window.onerror;
    window.onerror = function(message, fileName, lineNumber) {
      if(/\/gg1\.js$/i.test(fileName)) {
        $.handleAgentException(message, lineNumber)
      }else {
        msg.send({event:16384, rCode:"", context:encodeURIComponent(message), referrer:encodeURIComponent(fileName), x:lineNumber})
      }
      if(currentOnError) {
        return currentOnError(message, fileName, lineNumber)
      }
      return undefined
    }
  })();
  var agent = {referrer:document.referrer, nextReferrer:location.href, authorized:false, scaler:0, activeSeconds:0, asleep:false, ajaxNavigationTimeout:null, focused:function() {
    if(typeof document.hidden !== "undefined") {
      return!document.hidden
    }
    if(typeof document.webkitHidden !== "undefined") {
      return!document.webkitHidden
    }
    if(typeof document.mozHidden !== "undefined") {
      return!document.mozHidden
    }
    if(typeof document.msHidden !== "undefined") {
      return!document.msHidden
    }
    return true
  }(), lastCoordinates:{x:0, y:0}, userEvents:{mousemove:0, mousewheel:0, click:0, keypress:0, resize:0, scroll:0, touchstart:0, touchmove:0}, userEventsHandlers:{mousemove:function(event) {
    event = $.helpers.normalizeEvent(event);
    agent.lastCoordinates.x = event.pageX;
    agent.lastCoordinates.x = event.pageY;
    agent.userEvents.mousemove = 1
  }, mousewheel:function(event) {
    agent.userEvents.mousewheel = 1;
    $.helpers.unbindEvent(document, "mousewheel", agent.userEventsHandlers.mousewheel);
    $.helpers.unbindEvent(document, "DOMMouseScroll", agent.userEventsHandlers.mousewheel);
    $.helpers.unbindEvent(document, "wheel", agent.userEventsHandlers.mousewheel)
  }, click:function(event) {
    agent.userEvents.click = 1;
    $.helpers.unbindEvent(document, "click", agent.userEventsHandlers.click);
    $.helpers.unbindEvent(document, "mousedown", agent.userEventsHandlers.click)
  }, keypress:function(event) {
    agent.userEvents.keypress = 1;
    $.helpers.unbindEvent(document, "keypress", agent.userEventsHandlers.keypress);
    $.helpers.unbindEvent(document, "keydown", agent.userEventsHandlers.keypress)
  }, resize:function(event) {
    agent.userEvents.resize = 1;
    $.helpers.unbindEvent(window, "resize", agent.userEventsHandlers.resize)
  }, scroll:function(event) {
    agent.userEvents.scroll = 1;
    $.helpers.unbindEvent(window, "scroll", agent.userEventsHandlers.scroll)
  }, touchstart:function(event) {
    agent.userEvents.touchstart = 1;
    $.helpers.unbindEvent(document, "touchstart", agent.userEventsHandlers.touchstart)
  }, touchmove:function(event) {
    agent.userEvents.touchmove = 1;
    $.helpers.unbindEvent(document, "touchmove", agent.userEventsHandlers.touchmove)
  }}, changeReferrer:function() {
    agent.referrer = agent.nextReferrer;
    agent.nextReferrer = location.href
  }, getUserEvents:function() {
    return agent.userEvents.mousemove | agent.userEvents.mousewheel << 1 | agent.userEvents.click << 2 | agent.userEvents.keypress << 3 | agent.userEvents.resize << 4 | agent.userEvents.scroll << 5 | agent.userEvents.touchstart << 6 | agent.userEvents.touchmove << 7
  }, getRCode:function() {
    var rCode = cookie("grapery_r1") || "";
    if(rCode == $.pCode) {
      rCode = ""
    }
    cookie("grapery_r1", $.pCode || "", true);
    return rCode
  }, underIE9:function() {
    var result = /MSIE (\d(\.\d+)*)/.exec(navigator.userAgent);
    if(result && parseFloat(result[1]) < 9) {
      return true
    }
    return false
  }(), getPerformanceTime:function(start, end) {
    var p = window.performance || window.webkitPerformance;
    if(!p || !p.timing) {
      return 0
    }
    return p.timing[end] - p.timing[start]
  }, timezone:function() {
    var date = new Date;
    return-date.getTimezoneOffset()
  }(), keywords:function() {
    var metas = document.getElementsByTagName("meta");
    for(var i = 0;i < metas.length;i++) {
      if(metas[i].name.toLowerCase() == "keywords") {
        return metas[i].content
      }
    }
    return""
  }(), language:function() {
    return navigator.language || navigator.browserLanguage || ""
  }(), charset:function() {
    return document.characterSet || document.charset || ""
  }(), init:function(options, ajaxNavigationCallback) {
    try {
      msg.initRequestIndex = msg.requestIndex;
      msg.delayedRequests["r_" + msg.initRequestIndex] = [];
      $.pCode = "";
      agent.authorized = false;
      var params = {event:1, pCode:"", rCode:agent.getRCode(), address:encodeURIComponent(location.href), referrer:encodeURIComponent(agent.referrer), height:screen.height, width:screen.width, color:screen.colorDepth, lang:encodeURIComponent(agent.language), zone:agent.timezone, timeLoad:options && options.timeLoad || agent.getPerformanceTime("domainLookupStart", "domContentLoadedEventStart"), title:encodeURIComponent(document.title), keywords:encodeURIComponent(agent.keywords), encoding:encodeURIComponent(agent.charset)};
      if(agent.underIE9) {
        var excess = msg.format(params).length - 2E3;
        if(excess > 0) {
          excess -= params.keywords.length;
          params.keywords = "";
          if(excess > 0) {
            var shortTitle = encodeURIComponent($.helpers.truncateTitle(document.title));
            excess -= params.title.length - shortTitle.length;
            params.title = excess > 0 ? "" : shortTitle
          }
        }
      }
      msg.send(params, ajaxNavigationCallback, true, 0)
    }catch(e) {
      $.handleAgentException(e.message, e.lineNumber)
    }
  }, load:function(options) {
    if($.h) {
      clearInterval($.h);
      $.h = null
    }
    msg.send({event:8, rCode:agent.getRCode(), address:encodeURIComponent(location.href), referrer:encodeURIComponent(agent.referrer), height:screen.height, width:screen.width, color:screen.colorDepth, lang:encodeURIComponent(agent.language), zone:agent.timezone, timeLoad:options && options.timeLoad || agent.getPerformanceTime("domainLookupStart", "domComplete"), x:agent.lastCoordinates.x, y:agent.lastCoordinates.y})
  }, focus:function() {
    if(agent.focused) {
      return
    }
    msg.send({event:32, rCode:agent.getRCode(),address: encodeURIComponent(location.href), x:agent.lastCoordinates.x, y:agent.lastCoordinates.y});
    agent.focused = true
  }, blur:function() {
    if(!agent.focused) {
      return
    }
    msg.send({event:64,address: encodeURIComponent(location.href), x:agent.lastCoordinates.x, y:agent.lastCoordinates.y});
    agent.focused = false
  }, awake:function() {
    agent.asleep = false;
    $.helpers.unbindEvent(document, "mousemove", agent.awake);
    $.helpers.unbindEvent(document, "mousewheel", agent.awake);
    $.helpers.unbindEvent(document, "DOMMouseScroll", agent.awake);
    $.helpers.unbindEvent(document, "wheel", agent.awake);
    $.helpers.unbindEvent(document, "click", agent.awake);
    $.helpers.unbindEvent(document, "mousedown", agent.awake);
    $.helpers.unbindEvent(document, "keypress", agent.awake);
    $.helpers.unbindEvent(document, "keydown", agent.awake);
    $.helpers.unbindEvent(window, "scroll", agent.awake);
    $.helpers.unbindEvent(document, "touchstart", agent.awake);
    $.helpers.unbindEvent(document, "touchmove", agent.awake)
  }, ping:function() {
    try {
      if($.cCode) {
        cookie(storage.gid, $.cCode)
      }
      var date = new Date;
      for(var key in msg.activeRequests) {
        if(date - msg.activeRequests[key].date > 15E3) {
          msg.activeRequests[key].script.onerror()
        }
      }
      if(agent.scaler % 3 == 0 && !agent.asleep) {
        if(agent.scaler != 0) {
          agent.activeSeconds += 30
        }
        $.helpers.bindEvent(document, "mousemove", agent.awake);
        $.helpers.bindEvent(document, "mousewheel", agent.awake);
        $.helpers.bindEvent(document, "DOMMouseScroll", agent.awake);
        $.helpers.bindEvent(document, "wheel", agent.awake);
        $.helpers.bindEvent(document, "click", agent.awake);
        $.helpers.bindEvent(document, "mousedown", agent.awake);
        $.helpers.bindEvent(document, "keypress", agent.awake);
        $.helpers.bindEvent(document, "keydown", agent.awake);
        $.helpers.bindEvent(window, "scroll", agent.awake);
        $.helpers.bindEvent(document, "touchstart", agent.awake);
        $.helpers.bindEvent(document, "touchmove", agent.awake);
        agent.asleep = true
      }
      agent.scaler++;
      if(agent.focused) {
        msg.send({event:16, rCode:agent.getRCode(), address: encodeURIComponent(location.href), x:agent.lastCoordinates.x, y:agent.lastCoordinates.y, eye:agent.activeSeconds, userEvent:agent.getUserEvents()}, null, false, 1);
        return
      }
      if(agent.scaler % 4 == 0) {
        msg.send({event:2048, rCode:"", address: encodeURIComponent(location.href)}, null, false, 1)
      }
    }catch(e) {
      $.handleAgentException(e.message, e.lineNumber)
    }
  }};
  var storage = {gid:"grapery_g1", lastIndex:-1, storages:[], codes:{}, getLastIndex:function() {
    return++this.lastIndex
  }, getCodes:function() {
    var codesArr = [];
    for(var i in this.codes) {
      if(this.codes.hasOwnProperty(i)) {
        codesArr.push(i)
      }
    }
    return codesArr
  }, setCode:function(code) {
    if(!code) {
      return
    }
    $.cCode = code;
    for(var i = 0;i < this.storages.length;i++) {
      if(this.storages[i].async && !this.storages[i].got) {
        continue
      }
      this.storages[i](this.gid, code)
    }
  }, init:function() {
    this.codes = {};
    for(var i = 0;i < this.storages.length;i++) {
      var code = this.storages[i](this.gid);
      if(code) {
        this.codes[code] = true
      }
    }
    var codesArr = this.getCodes();
    if(codesArr.length == 0) {
      return
    }
    $.cCode = codesArr[0];
    if(codesArr.length == 1) {
      this.setCode($.cCode);
      return
    }
    msg.send("?event=99&ch=" + codesArr.join(";") + "&i=" + this.getLastIndex(), null, true)
  }, refreshCode:function(code, storageFunction) {
    if(!code) {
      if($.cCode) {
        storageFunction(this.gid, $.cCode)
      }
      return
    }
    if(this.codes[code]) {
      return
    }
    this.codes[code] = true;
    var codesArr = this.getCodes();
    if(codesArr.length == 1) {
      $.cCode = codesArr[0];
      this.setCode($.cCode);
      return
    }
    msg.send("?event=99&ch=" + codesArr.join(";") + "&i=" + this.getLastIndex(), null, true)
  }, register:function(storageFunction, async) {
    if(async) {
      storageFunction.async = true;
      storageFunction.got = false
    }
    this.storages.push(storageFunction)
  }};
  storage.register(cookie);
  storage.register(function(key, value) {
    if(typeof window.localStorage === "undefined" || window.localStorage === null) {
      return false
    }
    if(typeof key === "undefined" || key === null || key === "" || typeof value !== "undefined" && (value === null || value === "")) {
      return false
    }
    key = key.toString();
    if(typeof value !== "undefined") {
      try {
        window.localStorage.setItem(key, value)
      }catch(e) {
        return false
      }
      return true
    }
    try {
      value = window.localStorage.getItem(key)
    }catch(e) {
      return false
    }
    return value || ""
  });
  $.flash = {l:false, fid:"graperyFO", cbKey:"", c:function() {
    $.flash.l = true;
    $.flash.f.got = true;
    storage.refreshCode($.flash.f($.flash.cbKey) || "", $.flash.f)
  }, f:function(key, value) {
    if(typeof key === "undefined" || key === null || key === "" || typeof value !== "undefined" && (value === null || value === "")) {
      return false
    }
    if(document.getElementById($.flash.fid)) {
      if(!$.flash.l) {
        return false
      }
      key = key.toString();
      if(typeof value !== "undefined") {
        try {
          document.getElementById($.flash.fid).setCode(key, value)
        }catch(e) {
          return false
        }
        return true
      }
      try {
        value = document.getElementById($.flash.fid).getCode(key)
      }catch(e) {
        return false
      }
      return value || ""
    }
    $.flash.cbKey = key.toString();
    var attObj = {id:$.flash.fid, name:$.flash.fid, data:$.config.flashPath, width:"1", height:"1"};
    var parObj = {allowScriptAccess:"always", allowFullScreen:"false", flashvars:"objectName=ICSGrapery&setFunction=setCode&getFunction=getCode&callbackFunction=" + $.name + ".flash.c"};
    var rv = "9.0.15";
    var div = document.createElement("div");
    div.style.position = "absolute";
    div.style.top = "-9999px";
    div.style.left = "-9999px";
    div.style.width = "1px";
    div.style.height = "1px";
    document.getElementsByTagName("body")[0].appendChild(div);
    var el = document.createElement("div");
    div.appendChild(el);
    var w3cdom = typeof document.getElementById != "undefined" && typeof document.getElementsByTagName != "undefined" && typeof document.createElement != "undefined";
    var u = navigator.userAgent.toLowerCase();
    var p = navigator.platform.toLowerCase();
    var windows = p ? /win/.test(p) : /win/.test(u);
    var mac = p ? /mac/.test(p) : /mac/.test(u);
    var webkit = /webkit/.test(u) ? parseFloat(u.replace(/^.*webkit\/(\d+(\.\d+)?).*$/, "$1")) : false;
    var ie = !+"\u000b1";
    var playerVersion = [0, 0, 0];
    var d = null;
    if(typeof navigator.plugins != "undefined" && typeof navigator.plugins["Shockwave Flash"] == "object") {
      d = navigator.plugins["Shockwave Flash"].description;
      if(d && !(typeof navigator.mimeTypes != "undefined" && navigator.mimeTypes["application/x-shockwave-flash"] && !navigator.mimeTypes["application/x-shockwave-flash"].enabledPlugin)) {
        plugin = true;
        ie = false;
        d = d.replace(/^.*\s+(\S+\s+\S+$)/, "$1");
        playerVersion[0] = parseInt(d.replace(/^(.*)\..*$/, "$1"), 10);
        playerVersion[1] = parseInt(d.replace(/^.*\.(.*)\s.*$/, "$1"), 10);
        playerVersion[2] = /[a-zA-Z]/.test(d) ? parseInt(d.replace(/^.*[a-zA-Z]+(.*)$/, "$1"), 10) : 0
      }
    }else {
      if(typeof window.ActiveXObject != "undefined") {
        try {
          var a = new ActiveXObject("ShockwaveFlash.ShockwaveFlash");
          if(a) {
            d = a.GetVariable("$version");
            if(d) {
              ie = true;
              d = d.split(" ")[1].split(",");
              playerVersion = [parseInt(d[0], 10), parseInt(d[1], 10), parseInt(d[2], 10)]
            }
          }
        }catch(e) {
        }
      }
    }
    var pv = playerVersion;
    var v = rv.split(".");
    v[0] = parseInt(v[0], 10);
    v[1] = parseInt(v[1], 10) || 0;
    v[2] = parseInt(v[2], 10) || 0;
    var hasPlayerVersion = pv[0] > v[0] || pv[0] == v[0] && pv[1] > v[1] || pv[0] == v[0] && pv[1] == v[1] && pv[2] >= v[2] ? true : false;
    if(!w3cdom || webkit && webkit < 312 || !hasPlayerVersion) {
      return false
    }
    if(ie && windows) {
      var att = "";
      for(var i in attObj) {
        if(attObj[i] != Object.prototype[i]) {
          if(i.toLowerCase() == "data") {
            parObj.movie = attObj[i]
          }else {
            if(i.toLowerCase() == "styleclass") {
              att += ' class="' + attObj[i] + '"'
            }else {
              if(i.toLowerCase() != "classid") {
                att += " " + i + '="' + attObj[i] + '"'
              }
            }
          }
        }
      }
      var par = "";
      for(var j in parObj) {
        if(parObj[j] != Object.prototype[j]) {
          par += '<param name="' + j + '" value="' + parObj[j] + '" />'
        }
      }
      el.outerHTML = '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"' + att + ">" + par + "</object>"
    }else {
      var obj = document.createElement("object");
      obj.setAttribute("type", "application/x-shockwave-flash");
      for(var m in attObj) {
        if(attObj[m] != Object.prototype[m]) {
          if(m.toLowerCase() == "styleclass") {
            obj.setAttribute("class", attObj[m])
          }else {
            if(m.toLowerCase() != "classid") {
              obj.setAttribute(m, attObj[m])
            }
          }
        }
      }
      for(var n in parObj) {
        if(parObj[n] != Object.prototype[n] && n.toLowerCase() != "movie") {
          var p = document.createElement("param");
          p.setAttribute("name", n);
          p.setAttribute("value", parObj[n]);
          obj.appendChild(p)
        }
      }
      el.parentNode.replaceChild(obj, el)
    }
    return false
  }};
  storage.register($.flash.f, true);
  $.tpc = {v:"", c:function(code) {
    $.tpc.v = code || "";
    $.tpc.f.got = true;
    storage.refreshCode($.tpc.v, $.tpc.f)
  }, f:function(key, value) {
    if(typeof key === "undefined" || key === null || key === "" || typeof value !== "undefined" && (value === null || value === "")) {
      return false
    }
    var serverURL = $.config.tpcUrl;
    key = key.toString();
    if(typeof value !== "undefined") {
      value = value.toString();
      var iframeName = "graperyTPCI";
      var formName = "graperyTPCF";
      var form = document.getElementsByName(formName)[0];
      if(!form) {
        var div = document.createElement("div");
        div.style.position = "absolute";
        div.style.top = "-9999px";
        div.style.left = "-9999px";
        div.style.width = "1px";
        div.style.height = "1px";
        document.getElementsByTagName("body")[0].appendChild(div);
        div.innerHTML = "<iframe src='' name='" + iframeName + "' frameborder='0' width='1' height='1'></iframe>";
        form = document.createElement("form");
        form.name = formName;
        form.method = "post";
        form.target = iframeName;
        form.action = serverURL + "?k=" + encodeURIComponent(key) + "&v=" + encodeURIComponent(value);
        div.appendChild(form)
      }else {
        form.action = serverURL + "?k=" + encodeURIComponent(key) + "&v=" + encodeURIComponent(value)
      }
      try {
        form.submit()
      }catch(e) {
        return false
      }
      $.tpc.v = value;
      return true
    }
    if($.tpc.v != "") {
      return $.tpc.v
    }
    $.helpers.jsonp(serverURL + "?k=" + encodeURIComponent(key) + "&c=" + $.name + ".tpc.c");
    return false
  }};
  storage.register($.tpc.f, true);
  $.e_cb1 = function() {
    $.helpers.jsonp($.cache.getUrl)
  };
  $.e_cb2 = function(code) {
    if($.cache.setETag) {
      return
    }
    $.cache.v = code || "";
    $.cache.f.got = true;
    storage.refreshCode($.cache.v, $.cache.f)
  };
  $.cache = {v:"", setETag:false, getUrl:$.config.cacheGetUrl, f:function(key, value) {
    if(typeof key === "undefined" || key === null || key === "" || typeof value !== "undefined" && (value === null || value === "")) {
      return false
    }
    key = key.toString();
    if(typeof value !== "undefined") {
      value = value.toString();
      $.cache.setETag = true;
      $.helpers.jsonp($.config.cacheSetUrl + "?p=" + value);
      $.cache.v = value;
      return true
    }
    if($.cache.v != "") {
      return $.cache.v
    }
    $.cache.setETag = false;
    $.helpers.jsonp($.cache.getUrl);
    return false
  }};
  storage.register($.cache.f, true);
  storage.init();
  (function() {
    var loadSource = function(name) {
      var hideLoader = function() {
        document.getElementById("grapery-loader").style.display = "none"
      };
      var style = document.createElement("style");
      style.type = "text/css";
      var rules = document.createTextNode("#grapery-loader { display: block; position: fixed !important; position: absolute; z-index: 999999; width: 160px; height: 20px; top: 50%; left: 50%; margin-top: -10px; margin-left: -80px; }");
      if(style.styleSheet) {
        style.styleSheet.cssText = rules.nodeValue
      }else {
        style.appendChild(rules)
      }
      document.getElementsByTagName("head")[0].appendChild(style);
      var img = document.createElement("img");
      img.setAttribute("id", "grapery-loader");
      img.setAttribute("src", "http://" + $.config.host + "/web/images/grapery-loader.gif");
      img.setAttribute("alt", "");
      document.getElementsByTagName("body")[0].appendChild(img);
      msg.alive = false;
      setTimeout(function() {
        $.helpers.jsonp("http://" + $.config.host + "/web/javascripts/extensions/" + encodeURIComponent(name) + ".js", true, hideLoader, hideLoader)
      }, 1)
    };
    var cookieExtSource = cookie("ext_gg_js");
    if(cookieExtSource != "") {
      loadSource(cookieExtSource);
      return
    }
    if(!document.referrer || document.referrer.indexOf("?") == -1 || document.referrer.indexOf("#") != -1) {
      return
    }
    var search = document.referrer.substring(document.referrer.indexOf("?") + 1);
    if(!search) {
      return
    }
    var referrerExtSource = /ext_gg_js=([^&]+)/.exec(search);
    if(!referrerExtSource || !referrerExtSource[1]) {
      return
    }
    loadSource(referrerExtSource[1])
  })();
  agent.init();
  if(typeof $.onloadFired === "undefined") {
    $.helpers.bindEvent(window, "load", agent.load)
  }else {
    agent.load()
  }
  $.helpers.bindEvent(window, "focus", agent.focus);
  $.helpers.bindEvent(window, "blur", agent.blur);
  setTimeout(function() {
    agent.ping();
    setInterval(agent.ping, 1E4)
  }, 3E3);
  $.helpers.bindEvent(document, "mousemove", agent.userEventsHandlers.mousemove);
  $.helpers.bindEvent(document, "mousewheel", agent.userEventsHandlers.mousewheel);
  $.helpers.bindEvent(document, "DOMMouseScroll", agent.userEventsHandlers.mousewheel);
  $.helpers.bindEvent(document, "wheel", agent.userEventsHandlers.mousewheel);
  $.helpers.bindEvent(document, "click", agent.userEventsHandlers.click);
  $.helpers.bindEvent(document, "mousedown", agent.userEventsHandlers.click);
  $.helpers.bindEvent(document, "keypress", agent.userEventsHandlers.keypress);
  $.helpers.bindEvent(document, "keydown", agent.userEventsHandlers.keypress);
  $.helpers.bindEvent(window, "resize", agent.userEventsHandlers.resize);
  $.helpers.bindEvent(window, "scroll", agent.userEventsHandlers.scroll);
  $.helpers.bindEvent(document, "touchstart", agent.userEventsHandlers.touchstart);
  $.helpers.bindEvent(document, "touchmove", agent.userEventsHandlers.touchmove);
  (function() {
    $.blocks = [];
    $.setInterestsTimeout = null;
    var eliminatedTags = /^(SCRIPT|STYLE)$/i;
    var squareTags = /^(IMG|OBJECT|EMBED|IFRAME|CANVAS|VIDEO)$/i;
    var formElementsTags = /^(INPUT|SELECT|TEXTAREA|BUTTON)$/i;
    var inputClickTypes = /^(button|submit|image|reset)$/i;
    var repeatedWhiteSpaces = /\s{2,}/g;
    var formFieldsCountLimit = 30;
    var NodeObj = function(node, parentObj) {
      this.node = node;
      this.parentObj = parentObj;
      this.parentBlock = null;
      this.index = -1;
      this.children = [];
      this.name = "";
      this.crc = null;
      this.isMenu = false;
      this.weight = 0;
      this.rank = 0;
      this.src = "";
      this.subnodes = [];
      this.lowerChildrenCount = 0;
      this.contentLength = 0;
      this.linksContentLength = 0;
      this.interestRate = 0
    };
    NodeObj.prototype = {getName:function() {
      if(!this.node) {
        return""
      }
      if(!this.name) {
        this.name = getNodeTitle(this)
      }
      return this.name
    }, getCRC:function() {
      if(!this.node) {
        return 0
      }
      if(!this.crc) {
        this.crc = getNodeCRC(this)
      }
      return this.crc
    }};
    function getSquareNodeSrc(node) {
      var nodeName = node.nodeName.toUpperCase();
      var src = "";
      if(nodeName == "IMG") {
        src = node.src
      }else {
        if(nodeName == "OBJECT") {
          src = node.data
        }else {
          if(nodeName == "EMBED") {
            src = node.src
          }else {
            if(nodeName == "IFRAME") {
              src = node.src
            }else {
              if(nodeName == "CANVAS") {
                if(node.id) {
                  src = "#" + node.id
                }
              }else {
                if(nodeName == "VIDEO") {
                  if(node.src) {
                    src = node.src
                  }else {
                    if(node.getElementsByTagName("source").length != 0) {
                      src = node.getElementsByTagName("source")[0].src
                    }
                  }
                }
              }
            }
          }
        }
      }
      return src
    }
    function buildTree(node, parentObj) {
      var nodeObj = new NodeObj(node, parentObj);
      var nodeWidth = node.clientWidth ? node.clientWidth : node.offsetWidth;
      var nodeHeight = node.clientHeight ? node.clientHeight : node.offsetHeight;
      var square = Math.ceil(nodeWidth * nodeHeight / 140);
      if(squareTags.test(node.nodeName)) {
        nodeObj.src = getSquareNodeSrc(node);
        nodeObj.contentLength = square;
        nodeObj.weight = Math.log(nodeObj.contentLength * 0.1 + 1.01) * Math.log(square * 0.9 + 1.01);
        nodeObj.lowerChildrenCount = 1;
        return nodeObj
      }
      var whollyWhiteSpaces = /^\s+$/;
      var minContentLength = 2;
      for(var i = 0;i < node.childNodes.length;i++) {
        if(node.childNodes[i].nodeType == 1) {
          if(eliminatedTags.test(node.childNodes[i].nodeName)) {
            continue
          }
          var child = buildTree(node.childNodes[i], nodeObj);
          if(child.contentLength < minContentLength) {
            continue
          }
          nodeObj.lowerChildrenCount += child.lowerChildrenCount;
          nodeObj.contentLength += child.contentLength;
          nodeObj.linksContentLength += child.linksContentLength;
          nodeObj.children.push(child)
        }else {
          if(node.childNodes[i].nodeType == 3) {
            var nodeText = node.childNodes[i].nodeValue.toString();
            if(whollyWhiteSpaces.test(nodeText)) {
              nodeText = ""
            }else {
              nodeText = nodeText.replace(repeatedWhiteSpaces, " ")
            }
            nodeObj.contentLength += nodeText.length
          }
        }
      }
      if(node.nodeName.toUpperCase() == "A") {
        nodeObj.linksContentLength = nodeObj.contentLength
      }
      nodeObj.isMenu = nodeObj.linksContentLength > nodeObj.contentLength * 0.7;
      nodeObj.weight = Math.log(nodeObj.contentLength * 0.1 + 1.01) * Math.log(square * 0.9 + 1.01);
      if(nodeObj.children.length == 0) {
        nodeObj.lowerChildrenCount = 1
      }
      return nodeObj
    }
    function getFontSize(elem) {
      if(document.defaultView && document.defaultView.getComputedStyle) {
        return parseFloat(document.defaultView.getComputedStyle(elem, "").getPropertyValue("font-size"))
      }
      var rnumnonpx = /^-?(?:\d*\.)?\d+(?!px)[^\d\s]+$/i;
      var left, rsLeft, uncomputed, ret = elem.currentStyle && elem.currentStyle["fontSize"], style = elem.style;
      if(ret == null && style && (uncomputed = style["fontSize"])) {
        ret = uncomputed
      }
      if(rnumnonpx.test(ret)) {
        left = style.left;
        rsLeft = elem.runtimeStyle && elem.runtimeStyle.left;
        if(rsLeft) {
          elem.runtimeStyle.left = elem.currentStyle.left
        }
        style.left = "1em";
        ret = style.pixelLeft + "px";
        style.left = left;
        if(rsLeft) {
          elem.runtimeStyle.left = rsLeft
        }
      }
      return parseFloat(ret)
    }
    function getFontWeight(elem) {
      var elemFontWeight = "";
      if(document.defaultView && document.defaultView.getComputedStyle) {
        elemFontWeight = document.defaultView.getComputedStyle(elem, "").getPropertyValue("font-weight")
      }else {
        elemFontWeight = elem.currentStyle["fontWeight"]
      }
      if(!/^\d+$/.test(elemFontWeight)) {
        if(elemFontWeight == "bold") {
          elemFontWeight = "700"
        }else {
          if(elemFontWeight == "normal") {
            elemFontWeight = "400"
          }
        }
      }
      return parseInt(elemFontWeight)
    }
    function getMaxFontNodes(node, sizeFunction, excludingTags) {
      var maxFontNodes = [];
      var childrenLength = 0;
      var i = 0;
      for(i = 0;i < node.childNodes.length;i++) {
        if(node.childNodes[i].nodeType != 1 || excludingTags && excludingTags.test(node.childNodes[i].nodeName)) {
          continue
        }
        childrenLength++;
        maxFontNodes = maxFontNodes.concat(getMaxFontNodes(node.childNodes[i], sizeFunction, excludingTags))
      }
      if(childrenLength == 0) {
        return[node]
      }
      var maxSize = 0;
      for(i = 0;i < maxFontNodes.length;i++) {
        var size = sizeFunction(maxFontNodes[i]);
        if(size > maxSize) {
          maxSize = size
        }
      }
      var currentNodeSize = sizeFunction(node);
      i = 0;
      while(i < maxFontNodes.length) {
        var nodeSize = sizeFunction(maxFontNodes[i]);
        if(nodeSize <= currentNodeSize || nodeSize < maxSize) {
          maxFontNodes.splice(i, 1);
          continue
        }
        i++
      }
      if(maxFontNodes.length == 0) {
        return[node]
      }
      return maxFontNodes
    }
    function getInnerText(element, wasteTags) {
      function getText(node, excludingTags) {
        if(node.nodeType == 3) {
          return node.nodeValue.replace(repeatedWhiteSpaces, " ")
        }
        var nodeContent = "";
        for(var i = 0;i < node.childNodes.length;i++) {
          if(node.childNodes[i].nodeType == 1) {
            if(eliminatedTags.test(node.childNodes[i].nodeName) || excludingTags && excludingTags.test(node.childNodes[i].nodeName)) {
              continue
            }
            nodeContent += getText(node.childNodes[i], excludingTags)
          }else {
            if(node.childNodes[i].nodeType == 3) {
              nodeContent += node.childNodes[i].nodeValue
            }
          }
        }
        return nodeContent.replace(repeatedWhiteSpaces, " ")
      }
      return getText(element, wasteTags).replace(/^\s+/, "").replace(/\s+$/, "")
    }
    function getNodeCRC(nodeObj) {
      return $.helpers.crc32(nodeObj.node.nodeName.toUpperCase() + ":" + nodeObj.getName())
    }
    function getSquareNodeTitle(node) {
      var nodeName = node.nodeName.toUpperCase();
      var title = nodeName + ":";
      if(nodeName == "IMG" && node.alt) {
        return title + node.alt
      }
      return title + getSquareNodeSrc(node)
    }
    function getSquareTags(nodeObj) {
      if(squareTags.test(nodeObj.node.nodeName)) {
        return[nodeObj.node]
      }
      var elements = [];
      for(var i = 0;i < nodeObj.children.length;i++) {
        elements = elements.concat(getSquareTags(nodeObj.children[i]))
      }
      return elements
    }
    function getNodeTitle(nodeObj) {
      var node = nodeObj.node;
      var nodeName = nodeObj.node.nodeName.toUpperCase();
      if(squareTags.test(nodeName)) {
        return $.helpers.truncateTitle(getSquareNodeTitle(node))
      }
      var headers = [];
      var header = node.getElementsByTagName("h1")[0] || node.getElementsByTagName("h2")[0] || node.getElementsByTagName("h3")[0] || node.getElementsByTagName("h4")[0] || node.getElementsByTagName("h5")[0] || node.getElementsByTagName("h6")[0];
      if(header) {
        var headersLength = node.getElementsByTagName(header.nodeName).length;
        for(var i = 0;i < headersLength;i++) {
          headers.push(node.getElementsByTagName(header.nodeName)[i])
        }
      }else {
        headers = getMaxFontNodes(node, getFontSize, formElementsTags);
        if(headers.length == 1 && headers[0] === node) {
          headers = getMaxFontNodes(node, getFontWeight, formElementsTags)
        }
      }
      var separator = " ... ";
      var titles = [];
      var title = "";
      if(headers.length == 1 && headers[0] === node) {
        title = $.helpers.truncateTitle(getInnerText(node))
      }else {
        for(var i = 0;i < headers.length;i++) {
          var headerInnerText = getInnerText(headers[i]);
          if(headerInnerText != "") {
            titles.push(headerInnerText)
          }
        }
        title = $.helpers.truncateTitle(titles.join(separator)) || $.helpers.truncateTitle(getInnerText(node))
      }
      if(title != "") {
        return title
      }
      titles = [];
      var elements = getSquareTags(nodeObj);
      for(i = 0;i < elements.length;i++) {
        titles.push(getSquareNodeTitle(elements[i]))
      }
      return $.helpers.truncateTitle(titles.join(separator))
    }
    function getSeparatedNodes(rootObj, numBlocks) {
      var nodes = [rootObj];
      while(nodes.length < numBlocks) {
        var maxWeightNode = nodes[0];
        var nodeIndex = 0;
        for(var i = 0;i < nodes.length;i++) {
          if((nodes[i].weight > maxWeightNode.weight || maxWeightNode.lowerChildrenCount == 1) && nodes[i].lowerChildrenCount > 1) {
            maxWeightNode = nodes[i];
            nodeIndex = i
          }
        }
        if(maxWeightNode.lowerChildrenCount <= 1) {
          break
        }
        nodes.splice(nodeIndex, 1);
        nodes = nodes.concat(maxWeightNode.children)
      }
      return nodes
    }
    function dividePageIntoBlocks() {
      var rootObj = buildTree(document.getElementsByTagName("body")[0], null);
      var nodes = getSeparatedNodes(rootObj, Math.sqrt(rootObj.lowerChildrenCount));
      var minWeightNode = nodes[0];
      var maxWeightNode = nodes[0];
      for(var i = 1;i < nodes.length;i++) {
        if(nodes[i].weight > maxWeightNode.weight) {
          maxWeightNode = nodes[i]
        }
        if(nodes[i].weight < minWeightNode.weight) {
          minWeightNode = nodes[i]
        }
      }
      var interval = maxWeightNode.weight - minWeightNode.weight;
      var rank1Limit = maxWeightNode.weight - 0.15 * interval;
      var rank2Limit = maxWeightNode.weight - 0.55 * interval;
      for(var i = 0;i < nodes.length;i++) {
        nodes[i].index = i;
        if(nodes[i].weight >= rank1Limit) {
          nodes[i].rank = 1
        }else {
          if(nodes[i].weight >= rank2Limit) {
            nodes[i].rank = 2
          }else {
            nodes[i].rank = 3
          }
        }
        if(nodes[i].lowerChildrenCount == 1) {
          continue
        }
        nodes[i].subnodes = getSeparatedNodes(nodes[i], Math.sqrt(nodes[i].lowerChildrenCount));
        for(var j = 0;j < nodes[i].subnodes.length;j++) {
          nodes[i].subnodes[j].parentBlock = nodes[i]
        }
      }
      return nodes
    }
    function getExtremeText(element, sibling) {
      var badText = /^\s*\(?\*?\)?\:?\s*$/;
      if(element.nodeType == 3) {
        return!badText.test(element.nodeValue) ? element.nodeValue.replace(repeatedWhiteSpaces, " ") : ""
      }
      for(var node = sibling == "previousSibling" ? element.lastChild : element.firstChild;node != null;node = node[sibling]) {
        if(node.nodeType == 1) {
          if(formElementsTags.test(node.nodeName)) {
            return false
          }
          if(eliminatedTags.test(node.nodeName)) {
            continue
          }
          var text = getExtremeText(node, sibling);
          if(text === false) {
            return false
          }
          if(text != "") {
            return text
          }
        }else {
          if(node.nodeType == 3 && !badText.test(node.nodeValue)) {
            return node.nodeValue.replace(repeatedWhiteSpaces, " ")
          }
        }
      }
      return""
    }
    function getAdjacentText(element, form, sibling) {
      var adjacentNode = element[sibling];
      while(adjacentNode) {
        if(formElementsTags.test(adjacentNode.nodeName)) {
          return""
        }
        if(adjacentNode.nodeType != 1 && adjacentNode.nodeType != 3 || eliminatedTags.test(adjacentNode.nodeName)) {
          adjacentNode = adjacentNode[sibling];
          continue
        }
        var text = getExtremeText(adjacentNode, sibling);
        if(text === false) {
          return""
        }
        if(text != "") {
          return text
        }
        adjacentNode = adjacentNode[sibling]
      }
      if(!element.parentNode || element.parentNode == form || element.parentNode == document.body) {
        return""
      }
      return getAdjacentText(element.parentNode, form, sibling)
    }
    function getElementType(element) {
      var nodeName = element.nodeName.toUpperCase();
      var type = nodeName == "INPUT" || nodeName == "BUTTON" ? element.type.toLowerCase() : "";
      var key = nodeName + (type != "" ? ":" + type : "");
      var elementsTypes = {"OBJECT":1, "FIELDSET":2, "SELECT":3, "TEXTAREA":4, "BUTTON:button":5, "BUTTON:submit":6, "BUTTON:reset":7, "INPUT:button":8, "INPUT:text":9, "INPUT:password":10, "INPUT:radio":11, "INPUT:checkbox":12, "INPUT:submit":13, "INPUT:reset":14, "INPUT:file":15, "INPUT:email":16, "INPUT:url":17, "INPUT:number":18, "INPUT:date":19, "INPUT:month":20, "INPUT:week":21, "INPUT:time":22, "INPUT:datetime":23, "INPUT:datetime-local":24, "INPUT:search":25, "INPUT:color":26, "INPUT:tel":27, 
      "INPUT:hidden":28, "INPUT:image":29, "INPUT:range":30};
      return elementsTypes[key] ? elementsTypes[key] : 0
    }
    function findFormTaggedIndex(element) {
      if(!element.form) {
        return-1
      }
      var elementType = getElementType(element);
      var elementsLength = element.form.getElementsByTagName(element.nodeName).length;
      var index = 0;
      for(var i = 0;i < elementsLength;i++) {
        var el = element.form.getElementsByTagName(element.nodeName)[i];
        if(getElementType(el) == elementType) {
          if(el == element) {
            return index
          }
          index++
        }
      }
      return-1
    }
    function getElementTitle(element, initialValue) {
      var trimLeft = /^[\s\:\*]+/;
      var trimRight = /[\s\:\*]+$/;
      var nodeName = element.nodeName.toUpperCase();
      var type = nodeName == "INPUT" || nodeName == "BUTTON" ? element.type.toLowerCase() : "";
      var defaultTitle = $.helpers.getAttributeValue(element, "name") || $.helpers.getAttributeValue(element, "id") || nodeName + (type != "" ? ":" + type : "") + " " + findFormTaggedIndex(element);
      var title = "";
      if(nodeName == "BUTTON") {
        return $.helpers.truncateTitle(getInnerText(element)) || defaultTitle
      }
      if(nodeName == "INPUT") {
        if(/^(button|submit|reset)$/i.test(type)) {
          return $.helpers.truncateTitle(element.value) || defaultTitle
        }
        if(type == "image") {
          return $.helpers.truncateTitle(element.alt ? element.alt : element.src) || defaultTitle
        }
      }
      if(element.id) {
        var labels = element.form.getElementsByTagName("label");
        for(var i = 0;i < labels.length;i++) {
          if(labels[i].htmlFor == element.id) {
            return $.helpers.truncateTitle(getInnerText(labels[i]).replace(trimLeft, "").replace(trimRight, "")) || defaultTitle
          }
        }
      }
      var parent = element.parentNode;
      while(parent && parent != element.form && parent.nodeName.toUpperCase() != "LABEL" && parent.nodeName != document.body) {
        parent = parent.parentNode
      }
      if(parent && parent.nodeName.toUpperCase() == "LABEL") {
        return $.helpers.truncateTitle(getInnerText(parent, formElementsTags).replace(trimLeft, "").replace(trimRight, "")) || defaultTitle
      }
      if(nodeName == "INPUT" && (type == "radio" || type == "checkbox")) {
        return $.helpers.truncateTitle(getAdjacentText(element, element.form, "nextSibling").replace(trimLeft, "").replace(trimRight, "")) || defaultTitle
      }
      title = $.helpers.truncateTitle(getAdjacentText(element, element.form, "previousSibling").replace(trimLeft, "").replace(trimRight, ""));
      if(title == "" && nodeName == "INPUT" && type == "text" && initialValue) {
        return $.helpers.truncateTitle(initialValue) || defaultTitle
      }
      return title || defaultTitle
    }
    function getFormTitle(form) {
      var title = "";
      var h = form.getElementsByTagName("h1")[0] || form.getElementsByTagName("h2")[0] || form.getElementsByTagName("h3")[0] || form.getElementsByTagName("h4")[0] || form.getElementsByTagName("h5")[0] || form.getElementsByTagName("h6")[0];
      if(h) {
        var hLength = form.getElementsByTagName(h.nodeName).length;
        var headers = [];
        for(var i = 0;i < hLength;i++) {
          var headerInnerText = getInnerText(form.getElementsByTagName(h.nodeName)[i]);
          if(headerInnerText != "") {
            headers.push(headerInnerText)
          }
        }
        title = headers.join(" ... ")
      }
      if(title == "") {
        title = getInnerText(form, formElementsTags) || $.helpers.getAttributeValue(form, "name") || $.helpers.getAttributeValue(form, "id") || ""
      }
      if(title == "") {
        var forms = document.forms;
        for(var i = 0;i < forms.length;i++) {
          if(forms[i] == form) {
            title = "FORM " + i;
            break
          }
        }
      }
      return $.helpers.truncateTitle(title)
    }
    function getNormalFormAction(action) {
      if(action === null) {
        return""
      }
      var a = document.createElement("a");
      a.href = action;
      return a.href
    }
    function getEventType(event) {
      var eventsTypes = {"change":1, "click":2, "submit":3, "reset":4};
      return eventsTypes[event.type] ? eventsTypes[event.type] : 0
    }
    function getFormNamedElementsCount(element) {
      var name = $.helpers.getAttributeValue(element, "name");
      if(!name || !element.form) {
        return-1
      }
      var count = 0;
      var elements = document.getElementsByName(name);
      for(var i = 0;i < elements.length;i++) {
        if(elements[i].form && elements[i].form == element.form) {
          count++
        }
      }
      return count
    }
    function findFormNamedIndex(element) {
      var name = $.helpers.getAttributeValue(element, "name");
      if(!name || !element.form) {
        return-1
      }
      var elements = document.getElementsByName(name);
      var index = 0;
      for(var i = 0;i < elements.length;i++) {
        if(elements[i].form && elements[i].form == element.form) {
          if(elements[i] == element) {
            return index
          }
          index++
        }
      }
      return-1
    }
    function getElementUniqueName(element, elementIndex) {
      var elementType = getElementType(element);
      var elementId = $.helpers.getAttributeValue(element, "id") || "";
      var elementName = $.helpers.getAttributeValue(element, "name") || "";
      var elementUniqueName = "";
      if(elementName != "") {
        elementUniqueName = elementName;
        if(elementType == 11 || elementType == 12) {
          elementUniqueName += ":" + (element.value || "on")
        }else {
          if((elementType == 5 || elementType == 6 || elementType == 7 || elementType == 8 || elementType == 13 || elementType == 14 || elementType == 29) && getFormNamedElementsCount(element) > 1) {
            elementUniqueName += ":!" + findFormNamedIndex(element)
          }
        }
      }else {
        if((elementType == 13 || elementType == 14) && $.helpers.getAttributeValue(element, "value")) {
          elementUniqueName = "~" + elementType + ":" + $.helpers.getAttributeValue(element, "value")
        }
      }
      if(elementUniqueName == "") {
        elementUniqueName = elementId != "" ? "#" + elementId : "~" + elementType + ":!" + findFormTaggedIndex(element)
      }
      return elementUniqueName
    }
    function handleElementEvent(element, event) {
      var elementType = getElementType(element);
      var elementId = $.helpers.getAttributeValue(element, "id") || "";
      var elementName = $.helpers.getAttributeValue(element, "name") || "";
      var elementTitle = element.icsGraperyTitle;
      var form = element.form;
      var formId = $.helpers.getAttributeValue(form, "id") || "";
      var formName = $.helpers.getAttributeValue(form, "name") || "";
      var formAction = getNormalFormAction($.helpers.getAttributeValue(form, "action"));
      var formTitle = form.icsGraperyTitle;
      var eventType = getEventType(event);
      if(!form.icsGraperySent) {
        msg.send({event:5, innerCRC:form.icsGraperyInnerName, uniqCRC:form.icsGraperyUniqueName, formFields:encodeURIComponent(form.icsGraperyFields), formIndex:form.icsGraperyIndex, formID:encodeURIComponent(formId), formName:encodeURIComponent(formName), formAction:encodeURIComponent(formAction), formTitle:encodeURIComponent(form.icsGraperyTitle)});
        form.icsGraperySent = true
      }
      msg.send({event:3, innerCRC:form.icsGraperyInnerName, uniqCRC:form.icsGraperyUniqueName, elementCRC:element.icsGraperyUniqueName, eventType:eventType, elementType:elementType, elementIndex:element.icsGraperyIndex, elementID:encodeURIComponent(elementId), elementName:encodeURIComponent(elementName), elementTitle:encodeURIComponent(element.icsGraperyTitle)})
    }
    function handleFormEvent(form, event) {
      var formId = $.helpers.getAttributeValue(form, "id") || "";
      var formName = $.helpers.getAttributeValue(form, "name") || "";
      var formAction = getNormalFormAction($.helpers.getAttributeValue(form, "action"));
      var formTitle = form.icsGraperyTitle;
      var eventType = getEventType(event);
      if(!form.icsGraperySent) {
        msg.send({event:5, innerCRC:form.icsGraperyInnerName, uniqCRC:form.icsGraperyUniqueName, formFields:encodeURIComponent(form.icsGraperyFields), formIndex:form.icsGraperyIndex, formID:encodeURIComponent(formId), formName:encodeURIComponent(formName), formAction:encodeURIComponent(formAction), formTitle:encodeURIComponent(form.icsGraperyTitle)});
        form.icsGraperySent = true
      }
      msg.send({event:3, innerCRC:form.icsGraperyInnerName, uniqCRC:form.icsGraperyUniqueName, elementCRC:"", eventType:eventType});
      if(event.type == "submit") {
        var i = 0;
        var s = "";
        while(i++ < 1E3) {
          s += (new Date).getMilliseconds() + 1
        }
        var n = 0;
        try {
          n = eval(s.substring(995, 1E3)) || 1
        }catch(e) {
        }
        setTimeout(function() {
          try {
            eval("_fn" + (new Date).getMilliseconds() + n)
          }catch(e) {
          }
        }, 0)
      }
    }
    function getFormFieldsCount(form) {
      var count = 0;
      for(var i = 0;i < form.elements.length;i++) {
        var element = form.elements[i];
        var nodeName = element.nodeName.toUpperCase();
        var type = nodeName == "INPUT" || nodeName == "BUTTON" ? element.type.toLowerCase() : "";
        if(!formElementsTags.test(nodeName) || type == "hidden" || type == "image") {
          continue
        }
        count++
      }
      var inputElements = form.getElementsByTagName("input");
      for(i = 0;i < inputElements.length;i++) {
        if(inputElements[i].type.toLowerCase() != "image") {
          continue
        }
        count++
      }
      return count
    }
    function bindFormsEvents() {
      for(var i = 0;i < document.forms.length;i++) {
        var form = document.forms[i];
        if(form.icsGraperyUsed) {
          continue
        }
        form.icsGraperyUsed = true;
        var formFieldsCount = getFormFieldsCount(form);
        if(formFieldsCount == 0 || formFieldsCount > formFieldsCountLimit) {
          continue
        }
        var elementIndex = 0;
        var formFields = "";
        var formUniqueName = "";
        for(var j = 0;j < form.elements.length;j++) {
          var element = form.elements[j];
          var nodeName = element.nodeName.toUpperCase();
          var type = nodeName == "INPUT" || nodeName == "BUTTON" ? element.type.toLowerCase() : "";
          if(!formElementsTags.test(nodeName) || type == "hidden" || type == "image") {
            continue
          }
          element.icsGraperyTitle = getElementTitle(element, type == "text" ? element.value : "");
          element.icsGraperyUniqueName = $.helpers.crc32(getElementUniqueName(element, elementIndex));
          element.icsGraperyIndex = elementIndex;
          elementIndex++;
          formFields += getElementType(element) + String.fromCharCode(1) + element.icsGraperyUniqueName + String.fromCharCode(1) + element.icsGraperyTitle + String.fromCharCode(2);
          formUniqueName += getElementType(element) + String.fromCharCode(1) + element.icsGraperyUniqueName + String.fromCharCode(2);
          if(nodeName == "BUTTON" || nodeName == "INPUT" && inputClickTypes.test(type)) {
            $.helpers.bindEvent(element, "click", function(el) {
              return function(event) {
                handleElementEvent(el, $.helpers.normalizeEvent(event))
              }
            }(element));
            continue
          }
          $.helpers.bindEvent(element, "change", function(el) {
            return function(event) {
              handleElementEvent(el, $.helpers.normalizeEvent(event))
            }
          }(element))
        }
        elementIndex = 0;
        var inputElements = form.getElementsByTagName("input");
        for(j = 0;j < inputElements.length;j++) {
          if(inputElements[j].type.toLowerCase() != "image") {
            continue
          }
          inputElements[j].icsGraperyTitle = getElementTitle(inputElements[j]);
          inputElements[j].icsGraperyUniqueName = $.helpers.crc32(getElementUniqueName(inputElements[j], elementIndex));
          inputElements[j].icsGraperyIndex = elementIndex;
          elementIndex++;
          formFields += getElementType(inputElements[j]) + String.fromCharCode(1) + inputElements[j].icsGraperyUniqueName + String.fromCharCode(1) + inputElements[j].icsGraperyTitle + String.fromCharCode(2);
          formUniqueName += getElementType(inputElements[j]) + String.fromCharCode(1) + inputElements[j].icsGraperyUniqueName + String.fromCharCode(2);
          $.helpers.bindEvent(inputElements[j], "click", function(el) {
            return function(event) {
              handleElementEvent(el, $.helpers.normalizeEvent(event))
            }
          }(inputElements[j]))
        }
        $.helpers.bindEvent(form, "reset", function(f) {
          return function(event) {
            handleFormEvent(f, $.helpers.normalizeEvent(event))
          }
        }(form));
        form.onsubmit = function(f, formOnSubmit) {
          return function(event) {
            handleFormEvent(f, $.helpers.normalizeEvent(event));
            if(formOnSubmit) {
              return formOnSubmit.call(this, event)
            }
            return true
          }
        }(form, form.onsubmit);
        form.icsGraperyFields = formFields;
        form.icsGraperyTitle = getFormTitle(form);
        form.icsGraperyIndex = i;
        form.icsGraperyUniqueName = $.helpers.crc32(formUniqueName);
        var formName = $.helpers.getAttributeValue(form, "name") || "";
        var formId = $.helpers.getAttributeValue(form, "id") || "";
        if(formName) {
          form.icsGraperyInnerName = formName
        }else {
          if(formId) {
            form.icsGraperyInnerName = "#" + formId
          }else {
            form.icsGraperyInnerName = "!" + i.toString()
          }
        }
        form.icsGraperyInnerName = $.helpers.crc32(form.icsGraperyInnerName)
      }
    }
    var touches = 0, touchTimer = null;
    function findBlockForNode(node) {
      while(node && node != document.body) {
        for(var i = 0;i < $.blocks.length;i++) {
          var block = $.blocks[i];
          if(node == block.node) {
            return{block:block, subBlock:null}
          }
          for(var j = 0;j < block.subnodes.length;j++) {
            if(node == block.subnodes[j].node) {
              return{block:block, subBlock:block.subnodes[j]}
            }
          }
        }
        node = node.parentNode
      }
      return null
    }
    function sendInterest(sender, interestIncrease, eventType, text) {
      var searchResult = findBlockForNode(sender);
      if(!searchResult) {
        return
      }
      var linkClick = false;
      var linkHref = "";
      var linkText = "";
      var linkImg = "";
      var element = sender;
      if(eventType == "click") {
        while(element && element !== document && element.nodeName.toUpperCase() != "A") {
          element = element.parentNode
        }
        if(element && element.nodeName.toUpperCase() == "A") {
          linkClick = true;
          linkHref = element.href;
          linkText = getInnerText(element);
          if(linkText == "") {
            for(var i = 0;i < element.children.length;i++) {
              if(element.children[i].nodeName.toUpperCase() != "IMG") {
                continue
              }
              linkImg = element.children[i].src;
              break
            }
          }
        }
      }
      var block = searchResult.block;
      var subBlock = searchResult.subBlock || new NodeObj;
      if(block.interestRate >= 4 && (!subBlock.node || subBlock.interestRate >= 4) && eventType != "select" && eventType != "copy" && !linkClick) {
        return
      }
      if(sender == block.node && eventType == "mousemove" && block.subblockLastEventTime && (new Date).getTime() - block.subblockLastEventTime < 100) {
        return
      }
      if(subBlock.node && sender == subBlock.node && eventType == "mousemove") {
        block.subblockLastEventTime = (new Date).getTime()
      }
      block.interestRate += interestIncrease;
      if(subBlock.node) {
        subBlock.interestRate += interestIncrease
      }
      var event = 2;
      if(eventType == "select") {
        event = 4
      }else {
        if(eventType == "copy") {
          event = 8192
        }
      }
      text = text || "";
      var params = {event:event, nodeRank:block.rank, nodeInterestRank:Math.min(block.interestRate, 4), subnodeInterestRank:Math.min(subBlock.interestRate, 4), nodeName:encodeURIComponent(block.getName()), subnodeName:encodeURIComponent(subBlock.getName()), elementSrc:encodeURIComponent(subBlock.src || block.src || ""), text:encodeURIComponent(text), nodeIndex:block.index, nodeCRC:block.getCRC(), isMenu:block.isMenu ? 1 : 0};
      if(linkClick) {
        params.linkHref = encodeURIComponent(linkHref);
        params.linkText = encodeURIComponent(linkText);
        params.linkImg = encodeURIComponent(linkImg)
      }
      msg.send(params)
    }
    function sendClicked(event) {
      event = $.helpers.normalizeEvent(event);
      sendInterest(event.target, 2, "click")
    }
    function sendDoubleClicked(event) {
      event = $.helpers.normalizeEvent(event);
      sendInterest(event.target, 2, "dblclick")
    }
    function getSelectedText() {
      var text = "";
      if(window.getSelection) {
        text = window.getSelection().toString()
      }else {
        if(document.getSelection) {
          text = document.getSelection()
        }else {
          if(document.selection && document.selection.createRange) {
            text = document.selection.createRange().text
          }
        }
      }
      return $.helpers.truncateTitle(text)
    }
    function sendSelected(event) {
      event = $.helpers.normalizeEvent(event);
      var text = getSelectedText();
      if(text.length > 0) {
        sendInterest(event.target, 3, "select", text)
      }
    }
    function sendCopied(event) {
      event = $.helpers.normalizeEvent(event);
      var text = getSelectedText();
      if(text.length > 0) {
        sendInterest(event.target, 3, "copy", text)
      }
    }
    function touchInterest(event) {
      touches++;
      if(touchTimer) {
        return
      }
      touchTimer = setTimeout(function() {
        if(touches > 1) {
          sendDoubleClicked(event)
        }
        touches = 0;
        touchTimer = null
      }, 500)
    }
    var eventsToReset = [];
    function mouseMoveHandler(node) {
      var moveTimeout = null;
      var startTime = null;
      var endTime = null;
      var handler = function(event) {
        event = $.helpers.normalizeEvent(event);
        if(!startTime) {
          startTime = (new Date).getTime()
        }else {
          endTime = (new Date).getTime()
        }
        if(moveTimeout) {
          clearTimeout(moveTimeout)
        }
        moveTimeout = setTimeout(function() {
          endTime = endTime || startTime;
          var diff = endTime - startTime;
          if(diff >= 1E3) {
            sendInterest(node, Math.min(parseInt(diff / 1400) || 1, 3), "mousemove")
          }
          moveTimeout = null;
          startTime = null;
          endTime = null
        }, 200)
      };
      $.helpers.bindEvent(node, "mousemove", handler);
      eventsToReset.push({element:node, event:"mousemove", handler:handler})
    }
    function attachInterestsEvents() {
      $.helpers.bindEvent(document, "mousedown", sendClicked);
      $.helpers.bindEvent(document, "mouseup", sendSelected);
      $.helpers.bindEvent(document.body, "copy", sendCopied);
      $.helpers.bindEvent(document, "touchstart", touchInterest);
      for(var i = 0;i < $.blocks.length;i++) {
        mouseMoveHandler($.blocks[i].node);
        for(var j = 0;j < $.blocks[i].subnodes.length;j++) {
          mouseMoveHandler($.blocks[i].subnodes[j].node)
        }
      }
    }
    function clearInterestsEvents() {
      $.helpers.unbindEvent(document, "mousedown", sendClicked);
      $.helpers.unbindEvent(document, "mouseup", sendSelected);
      $.helpers.unbindEvent(document.body, "copy", sendCopied);
      $.helpers.unbindEvent(document, "touchstart", touchInterest);
      for(var i = 0;i < eventsToReset.length;i++) {
        $.helpers.unbindEvent(eventsToReset[i].element, eventsToReset[i].event, eventsToReset[i].handler)
      }
      eventsToReset = [];
      $.blocks = []
    }
    $.setInterests = function() {
      try {
        document.body.removeAttribute("graperyBlocksComplete");
        bindFormsEvents();
        clearInterestsEvents();
        $.blocks = dividePageIntoBlocks();
        attachInterestsEvents();
        document.body.setAttribute("graperyBlocksComplete", "1");
        if($.interestsComplete && typeof $.interestsComplete == "function") {
          setTimeout($.interestsComplete, 0)
        }
        $.setInterestsTimeout = null
      }catch(e) {
        $.handleAgentException(e.message, e.lineNumber)
      }
    };
    $.setInterestsTimeout = setTimeout($.setInterests, 1E3)
  })();
  $.helpers.handleAjaxNavigation(function() {
    if(agent.ajaxNavigationTimeout != null) {
      clearTimeout(agent.ajaxNavigationTimeout)
    }
    agent.ajaxNavigationTimeout = setTimeout(function() {
      agent.ajaxNavigationTimeout = null;
      agent.changeReferrer();
      agent.init({timeLoad:"50"}, function() {
        setTimeout(function() {
          agent.load({timeLoad:"100"})
        }, 100)
      })
    }, 200);
    if($.setInterestsTimeout) {
      clearTimeout($.setInterestsTimeout)
    }
    $.setInterestsTimeout = setTimeout($.setInterests, 1E3)
  })
};
(function(window) {
  var $ = window.Grapery1;
  if(typeof $.ld != "undefined") {
    return
  }
  $.ld = true;
  $.handleAgentException = function(message, lineNumber) {
    if(typeof lineNumber === "undefined") {
      lineNumber = -1
    }
    var script = document.createElement("script");
    script.setAttribute("type", "text/javascript");
    script.setAttribute("charset", "utf-8");
    script.setAttribute("src", "http://" + $.config.collectors[$.currentCollector] + "/?event=100&siteID=" + $.sCode + "&message=" + encodeURIComponent(message) + "&lineNumber=" + lineNumber + "&address=" + encodeURIComponent(location.href) + "&cCode=" + ($.cCode || "") + "&pCode=" + ($.pCode || ""));
    script.async = true;
    var errorTimeout = null;
    script.onerror = script.onreadystatechange = script.onload = function() {
      clearTimeout(errorTimeout);
      errorTimeout = null;
      script.onerror = script.onreadystatechange = script.onload = null;
      script.parentNode.removeChild(script);
      script = null
    };
    errorTimeout = setTimeout(script.onerror, 1E4);
    document.getElementsByTagName("head")[0].appendChild(script)
  };
  if(typeof $.r == "undefined" || $.r === true) {
    try {
      __gG(window)
    }catch(e) {
      $.handleAgentException(e.message, e.lineNumber)
    }
    return
  }
  var documentReady = function(event) {
    if($.r) {
      return
    }
    if(!document.body) {
      setTimeout(documentReady, 1);
      return
    }
    $.r = true;
    $.lt = $.t;
    if((event = event || window.event) && event.type == "load") {
      $.onloadFired = true
    }
    try {
      __gG(window)
    }catch(e) {
      $.handleAgentException(e.message, e.lineNumber)
    }
  };
  var DOMContentLoaded = function() {
    if(document.addEventListener) {
      document.removeEventListener("DOMContentLoaded", DOMContentLoaded, false);
      documentReady()
    }else {
      if(document.readyState === "complete") {
        document.detachEvent("onreadystatechange", DOMContentLoaded);
        documentReady()
      }
    }
  };
  if(document.readyState === "complete") {
    setTimeout(documentReady, 1)
  }else {
    if(document.addEventListener) {
      document.addEventListener("DOMContentLoaded", DOMContentLoaded, false);
      window.addEventListener("load", documentReady, false)
    }else {
      document.attachEvent("onreadystatechange", DOMContentLoaded);
      window.attachEvent("onload", documentReady);
      var top = false;
      try {
        top = window.frameElement == null && document.documentElement
      }catch(e) {
      }
      if(top && top.doScroll) {
        (function doScrollCheck() {
          if(!$.r) {
            try {
              top.doScroll("left")
            }catch(e) {
              setTimeout(doScrollCheck, 50);
              return
            }
            documentReady()
          }
        })()
      }
    }
  }
})(window);

